/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import java.util.logging.Level;
import org.jacorb.idl.ArrayDeclarator;
import org.jacorb.idl.ArrayTypeSpec;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.Declarator;
import org.jacorb.idl.IDLTypes;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.Interface;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.SequenceType;
import org.jacorb.idl.TemplateTypeSpec;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.UnionType;
import org.jacorb.idl.parser;

public class ElementSpec
extends IdlSymbol {
    public TypeSpec typeSpec = new TypeSpec(ElementSpec.new_num());
    public Declarator declarator = null;
    private UnionType containingUnion;

    public ElementSpec(int num) {
        super(num);
    }

    @Override
    public void setPackage(String s) {
        s = parser.pack_replace(s);
        this.pack_name = this.pack_name.length() > 0 ? s + "." + this.pack_name : s;
        this.typeSpec.setPackage(s);
        this.declarator.setPackage(s);
    }

    public void setUnion(UnionType ut) {
        this.containingUnion = ut;
    }

    @Override
    public void setEnclosingSymbol(IdlSymbol s) {
        this.typeSpec.setEnclosingSymbol(s);
        this.declarator.setEnclosingSymbol(s);
    }

    @Override
    public void parse() {
        if (parser.logger.isLoggable(Level.ALL)) {
            parser.logger.log(Level.ALL, "EelementSpec.parse(): element_spec is " + this.typeSpec.typeSpec().getClass().getName());
        }
        boolean addName = true;
        if (this.typeSpec.typeSpec() instanceof TemplateTypeSpec || this.typeSpec.typeSpec() instanceof ConstrTypeSpec) {
            this.typeSpec.parse();
            if (this.typeSpec.typeSpec() instanceof SequenceType) {
                TypeSpec ts = ((SequenceType)this.typeSpec.typeSpec()).elementTypeSpec().typeSpec();
                SequenceType seqTs = (SequenceType)this.typeSpec.typeSpec();
                while (ts instanceof SequenceType) {
                    seqTs = (SequenceType)ts;
                    ts = ((SequenceType)ts.typeSpec()).elementTypeSpec().typeSpec();
                }
                if (ScopedName.isRecursionScope(ts.typeName())) {
                    ((SequenceType)seqTs.typeSpec()).setRecursive();
                }
            }
        } else if (this.typeSpec.typeSpec() instanceof ScopedName) {
            TypeSpec ts = ((ScopedName)this.typeSpec.typeSpec()).resolvedTypeSpec();
            if (ts.typeName().equals(this.containingUnion.typeName())) {
                parser.error("Illegal recursion in union " + this.containingUnion.full_name(), this.token);
            }
            this.containingUnion.addImportedName(ts.typeName());
            if (!(ts instanceof ConstrTypeSpec) || !(((ConstrTypeSpec)ts).declaration() instanceof Interface)) {
                this.typeSpec = ts;
            }
        }
        if (this.declarator.d instanceof ArrayDeclarator) {
            this.typeSpec = new ArrayTypeSpec(ElementSpec.new_num(), this.typeSpec, (ArrayDeclarator)this.declarator.d, this.containingUnion.full_name());
            this.typeSpec.parse();
            addName = false;
        }
        try {
            if (addName) {
                NameTable.define(this.containingUnion.full_name() + "." + this.declarator.name(), IDLTypes.DECLARATOR);
            }
        }
        catch (NameAlreadyDefined nad) {
            parser.error("Declarator " + this.declarator.name() + " already defined in union " + this.containingUnion.full_name(), this.token);
        }
        if (parser.logger.isLoggable(Level.ALL)) {
            parser.logger.log(Level.ALL, "ElementSpec.parse-end(): element_spec is " + this.typeSpec.typeSpec().getClass().getName());
        }
    }

    @Override
    public void print(PrintWriter ps) {
        if (this.typeSpec.typeSpec() instanceof TemplateTypeSpec || this.typeSpec.typeSpec() instanceof ConstrTypeSpec) {
            this.typeSpec.print(ps);
        }
    }
}

