/*
 * Decompiled with CFR 0.152.
 */
package csfs.datatransfer.nonblockingnio;

import csfs.datatransfer.nonblockingnio.GettingFileSize;
import csfs.datatransfer.nonblockingnio.ImportHandler;
import csfs.datatransfer.nonblockingnio.ImportState;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public class GettingPath
extends ImportState {
    private static final String ENCODING = "ISO-8859-1";
    private ByteBuffer buffer;

    public GettingPath(ImportHandler handler, int size) {
        this.buffer = ByteBuffer.allocate(size);
        this.remainingBytes = size;
        this.handler = handler;
    }

    @Override
    public void read() throws IOException {
        long bytesRead = this.handler.getSourceChannel().read(this.buffer);
        this.decRemainingBytes(bytesRead);
    }

    @Override
    protected void decRemainingBytes(long value) throws IOException {
        this.remainingBytes -= value;
        if (this.remainingBytes == 0L) {
            this.buffer.flip();
            Charset charset = Charset.forName(ENCODING);
            CharsetDecoder decoder = charset.newDecoder();
            CharBuffer charBuffer = decoder.decode(this.buffer);
            String fileName = charBuffer.toString();
            this.handler.setFilePath(fileName);
            this.handler.changeState(new GettingFileSize(this.handler));
        }
    }
}

