/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.InstantiatingComponentAdapter;
import org.picocontainer.defaults.LifecycleStrategy;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.defaults.PicoInvocationTargetInitializationException;
import org.picocontainer.defaults.ThreadLocalCyclicDependencyGuard;
import org.picocontainer.defaults.TooManySatisfiableConstructorsException;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class ConstructorInjectionComponentAdapter
extends InstantiatingComponentAdapter {
    private transient List sortedMatchingConstructors;
    private transient Guard instantiationGuard;

    public ConstructorInjectionComponentAdapter(Object object, Class clazz, Parameter[] parameterArray, boolean bl, ComponentMonitor componentMonitor, LifecycleStrategy lifecycleStrategy) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        super(object, clazz, parameterArray, bl, componentMonitor, lifecycleStrategy);
    }

    public ConstructorInjectionComponentAdapter(Object object, Class clazz, Parameter[] parameterArray, boolean bl, ComponentMonitor componentMonitor) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        super(object, clazz, parameterArray, bl, componentMonitor);
    }

    public ConstructorInjectionComponentAdapter(Object object, Class clazz, Parameter[] parameterArray, boolean bl) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        super(object, clazz, parameterArray, bl);
    }

    public ConstructorInjectionComponentAdapter(Object object, Class clazz, Parameter[] parameterArray) {
        this(object, clazz, parameterArray, false);
    }

    public ConstructorInjectionComponentAdapter(Object object, Class clazz) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        this(object, clazz, (Parameter[])null);
    }

    protected Constructor getGreediestSatisfiableConstructor(PicoContainer picoContainer) throws PicoIntrospectionException, UnsatisfiableDependenciesException, AmbiguousComponentResolutionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        HashSet<Constructor> hashSet = new HashSet<Constructor>();
        HashSet<List<Class>> hashSet2 = new HashSet<List<Class>>();
        if (this.sortedMatchingConstructors == null) {
            this.sortedMatchingConstructors = this.getSortedMatchingConstructors();
        }
        Constructor constructor = null;
        int n = -1;
        Class clazz = null;
        for (int i = 0; i < this.sortedMatchingConstructors.size(); ++i) {
            boolean bl = false;
            Constructor constructor2 = (Constructor)this.sortedMatchingConstructors.get(i);
            Class[] classArray = constructor2.getParameterTypes();
            Parameter[] parameterArray = this.parameters != null ? this.parameters : this.createDefaultParameters(classArray);
            for (int j = 0; j < parameterArray.length; ++j) {
                if (parameterArray[j].isResolvable(picoContainer, this, classArray[j])) continue;
                hashSet2.add(Arrays.asList(classArray));
                clazz = classArray[j];
                bl = true;
                break;
            }
            if (constructor != null && classArray.length != n) {
                if (hashSet.isEmpty()) {
                    return constructor;
                }
                hashSet.add(constructor2);
                continue;
            }
            if (!bl && n == classArray.length) {
                hashSet.add(constructor2);
                hashSet.add(constructor);
                continue;
            }
            if (bl) continue;
            constructor = constructor2;
            n = classArray.length;
        }
        if (!hashSet.isEmpty()) {
            throw new TooManySatisfiableConstructorsException(this.getComponentImplementation(), hashSet);
        }
        if (constructor == null && !hashSet2.isEmpty()) {
            throw new UnsatisfiableDependenciesException(this, clazz, hashSet2, picoContainer);
        }
        if (constructor == null) {
            HashSet<Constructor> hashSet3 = new HashSet<Constructor>();
            Constructor[] constructorArray = this.getConstructors();
            for (int i = 0; i < constructorArray.length; ++i) {
                hashSet3.add(constructorArray[i]);
            }
            throw new PicoInitializationException("Either do the specified parameters not match any of the following constructors: " + ((Object)hashSet3).toString() + " or the constructors were not accessible for '" + this.getComponentImplementation() + "'");
        }
        return constructor;
    }

    public Object getComponentInstance(PicoContainer picoContainer) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        if (this.instantiationGuard == null) {
            this.instantiationGuard = new Guard(){

                public Object run() {
                    Constructor constructor;
                    try {
                        constructor = ConstructorInjectionComponentAdapter.this.getGreediestSatisfiableConstructor(this.guardedContainer);
                    }
                    catch (AmbiguousComponentResolutionException ambiguousComponentResolutionException) {
                        ambiguousComponentResolutionException.setComponent(ConstructorInjectionComponentAdapter.this.getComponentImplementation());
                        throw ambiguousComponentResolutionException;
                    }
                    ComponentMonitor componentMonitor = ConstructorInjectionComponentAdapter.this.currentMonitor();
                    try {
                        Object[] objectArray = ConstructorInjectionComponentAdapter.this.getConstructorArguments(this.guardedContainer, constructor);
                        componentMonitor.instantiating(constructor);
                        long l = System.currentTimeMillis();
                        Object object = ConstructorInjectionComponentAdapter.this.newInstance(constructor, objectArray);
                        componentMonitor.instantiated(constructor, System.currentTimeMillis() - l);
                        return object;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        componentMonitor.instantiationFailed(constructor, invocationTargetException);
                        if (invocationTargetException.getTargetException() instanceof RuntimeException) {
                            throw (RuntimeException)invocationTargetException.getTargetException();
                        }
                        if (invocationTargetException.getTargetException() instanceof Error) {
                            throw (Error)invocationTargetException.getTargetException();
                        }
                        throw new PicoInvocationTargetInitializationException(invocationTargetException.getTargetException());
                    }
                    catch (InstantiationException instantiationException) {
                        componentMonitor.instantiationFailed(constructor, instantiationException);
                        throw new PicoInitializationException("Should never get here");
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        componentMonitor.instantiationFailed(constructor, illegalAccessException);
                        throw new PicoInitializationException(illegalAccessException);
                    }
                }
            };
        }
        this.instantiationGuard.setArguments(picoContainer);
        return this.instantiationGuard.observe(this.getComponentImplementation());
    }

    protected Object[] getConstructorArguments(PicoContainer picoContainer, Constructor constructor) {
        Class[] classArray = constructor.getParameterTypes();
        Object[] objectArray = new Object[classArray.length];
        Parameter[] parameterArray = this.parameters != null ? this.parameters : this.createDefaultParameters(classArray);
        for (int i = 0; i < parameterArray.length; ++i) {
            objectArray[i] = parameterArray[i].resolveInstance(picoContainer, this, classArray[i]);
        }
        return objectArray;
    }

    private List getSortedMatchingConstructors() {
        ArrayList<Constructor> arrayList = new ArrayList<Constructor>();
        Constructor[] constructorArray = this.getConstructors();
        for (int i = 0; i < constructorArray.length; ++i) {
            Constructor constructor = constructorArray[i];
            if (this.parameters != null && constructor.getParameterTypes().length != this.parameters.length || !this.allowNonPublicClasses && (constructor.getModifiers() & 1) == 0) continue;
            arrayList.add(constructor);
        }
        if (this.parameters == null) {
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((Constructor)object2).getParameterTypes().length - ((Constructor)object).getParameterTypes().length;
                }
            });
        }
        return arrayList;
    }

    private Constructor[] getConstructors() {
        return (Constructor[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ConstructorInjectionComponentAdapter.this.getComponentImplementation().getDeclaredConstructors();
            }
        });
    }

    private static abstract class Guard
    extends ThreadLocalCyclicDependencyGuard {
        protected PicoContainer guardedContainer;

        private Guard() {
        }

        private void setArguments(PicoContainer picoContainer) {
            this.guardedContainer = picoContainer;
        }
    }
}

