/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.portableInterceptor;

import java.util.List;
import java.util.Map;
import org.jacorb.orb.ORB;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.portableInterceptor.IORInfoExt;
import org.jacorb.poa.POA;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Policy;
import org.omg.ETF.Profile;
import org.omg.IOP.TaggedComponent;

public class IORInfoImpl
extends LocalObject
implements IORInfoExt {
    private final Map<Integer, TaggedComponentList> components;
    private final Map policy_overrides;
    private final ORB orb;
    private final POA poa;
    private final List<Profile> _profiles;

    public IORInfoImpl(ORB orb, POA poa, Map<Integer, TaggedComponentList> components, Map policy_overrides, List<Profile> profiles) {
        this.orb = orb;
        this.poa = poa;
        this.components = components;
        this.policy_overrides = policy_overrides;
        this._profiles = profiles;
    }

    public void add_ior_component(TaggedComponent component) {
        for (TaggedComponentList list : this.components.values()) {
            list.addComponent(component);
        }
    }

    public void add_ior_component_to_profile(TaggedComponent component, int id) {
        TaggedComponentList list = this.components.get(id);
        if (list == null) {
            throw new BAD_PARAM("unknown profile tag: " + id, 29, CompletionStatus.COMPLETED_MAYBE);
        }
        list.addComponent(component);
    }

    public Policy get_effective_policy(int type) {
        if (!this.orb.hasPolicyFactoryForType(type)) {
            throw new INV_POLICY("No PolicyFactory for type " + type + " has been registered!", 3, CompletionStatus.COMPLETED_MAYBE);
        }
        Policy policy = null;
        if (this.policy_overrides != null) {
            policy = (Policy)this.policy_overrides.get(type);
        }
        return policy != null ? policy : this.poa.getPolicy(type);
    }

    @Override
    public void add_profile(Profile profile) {
        if (this._profiles != null) {
            this._profiles.add(profile);
        }
    }

    @Override
    public int get_number_of_profiles(int tag) {
        int retVal = 0;
        for (int i = 0; i < this._profiles.size(); ++i) {
            Profile p = this._profiles.get(i);
            if (p.tag() != tag) continue;
            ++retVal;
        }
        return retVal;
    }

    @Override
    public Profile get_profile(int tag, int position) {
        int cnt = position;
        Profile result = null;
        for (int i = 0; i < this._profiles.size(); ++i) {
            Profile profile = this._profiles.get(i);
            if (profile.tag() == tag && cnt == 0) {
                result = profile;
                break;
            }
            --cnt;
        }
        if (result == null) {
            throw new ArrayIndexOutOfBoundsException("no profile with tag=" + tag + " at position" + position);
        }
        return result;
    }

    @Override
    public Profile get_profile(int tag) {
        Profile result = null;
        for (int i = 0; i < this._profiles.size(); ++i) {
            Profile profile = this._profiles.get(i);
            if (profile.tag() != tag) continue;
            result = profile;
            break;
        }
        return result;
    }
}

