-------------------------------------------------------------------------
-- $Author$
-- $Revision$  - $Date$
-------------------------------------------------------------------------

local verbose = require "sga.verbose"

-- Definição de modo verbose
-- verbose:level(1)
-- verbose:flag("top", false)


-------------------------------------------------------------------------
---------------------<:: CONFIGURAÇÂO AVANÇADA ::>-----------------------
-------------------------------------------------------------------------

-------------------------------------------------------------------------
-- Definição de intervalos de tempo no loop principal do SGA-Daemon
-- Os tempos comentados são os valores default.
-------------------------------------------------------------------------

-- Intervalo, em segundos, para buscar referencia do Servidor
SGAD_CONF.ssiref_time_seconds = SGAD_CONF.ssiref_time_seconds or 15

-- Intervalo, em segundos, para tentar registrar o SGA no Servidor
SGAD_CONF.sgaregistry_time_seconds = SGAD_CONF.sgaregistry_time_seconds or 30

-- Intervalo, em segundos, para leitura de uso de cpu/memória
SGAD_CONF.machine_time_seconds = SGAD_CONF.machine_time_seconds or 25

-- Intervalo, em segundos, para envio de informações dinâmicas ao servidor
SGAD_CONF.update_time_seconds = SGAD_CONF.update_time_seconds or 30

-- Intervalo, em segundos, para consulta de processos
SGAD_CONF.process_time_seconds = SGAD_CONF.process_time_seconds or 10

-- Intervalo, em segundos, para busca de comandos terminados
SGAD_CONF.completed_time_seconds = SGAD_CONF.completed_time_seconds or 10

-- Intervalo, em segundos, para dump de comandos em execução (persistencia)
SGAD_CONF.dump_time_seconds = SGAD_CONF.dump_time_seconds or 60

-- Numero de vezes que uma consulta (cpu/memória) deve falhar para
-- que seja considerado um erro.
SGAD_CONF.disregard_times = SGAD_CONF.disregard_times or 3

-- Número de vezes que tenta fazer o registro no Servidor quando ocorre
-- falha de comunicação. (OPCIONAL -- default é não ter limite)
--SGAD_CONF.retries_number = 5

-- Número de vezes que tenta iniciar o daemon do CSFS (OPCIONAL)
SGAD_CONF.csfs_retries_number = 5

-------------------------------------------------------------------------
-- EVITE ALTERAR as propriedades abaixo, configure as variáveis de
-- ambiente no arquivo sga-daemon de acordo com o necessário.
-------------------------------------------------------------------------

-------------------------------------------------------------------------
-- Nome da máquina onde será executado o sgad
-------------------------------------------------------------------------
local HOSTNAME = os.getenv("HOSTNAME")
if HOSTNAME then
   SGAD_CONF.domain = string.gsub(HOSTNAME, "^[^%.]+","")
   SGAD_CONF.localhost = string.gsub(HOSTNAME, "^([^%.]+).*","%1")
end

local HOST = os.getenv("HOST")
if not HOST then
   verbose:error("\n\nEnvironment variable $HOST is undefined!!!\n\n")
   os.exit(0)
end

HOST = string.gsub(HOST,"%..*","")
SGAD_CONF.name = HOST

-------------------------------------------------------------------------
--------------------------<:::::::::::::::::::>--------------------------
-------------------------------------------------------------------------

-------------------------------------------------------------------------
-- Localização do Servidor
-------------------------------------------------------------------------
SGAD_CONF.ssi_host = os.getenv("SSI_HOSTNAME") or "localhost"
SGAD_CONF.ssi_port = os.getenv("SSI_PORT") or "7778"
SGAD_CONF.ssi_printablename = SGAD_CONF.ssi_host..":"..SGAD_CONF.ssi_port
SGAD_CONF.sga_addr = os.getenv("SGA_ADDR")
SGAD_CONF.sandbox_root_directory = os.getenv("SGA_SANDBOX_DIR")
SGAD_CONF.project_root_directory = os.getenv("SSI_PROJECT_DIR")
SGAD_CONF.algorithm_root_directory = os.getenv("SSI_ALGORITHM_DIR")
SGAD_CONF.usrlibsdir = os.getenv("USR_LIBS_DIR")
SGAD_CONF.sgalibsdir = os.getenv("SGA_LIBS_DIR")
SGAD_CONF.path = os.getenv("PWD") or ""
SGAD_CONF.home = os.getenv("HOME") or ""

-- Para carregar a biblioteca apropriada...
-- @TODO Retirar a parte de carregar a lib deste arquivo
  -- local sganame = string.upper( SGAD_CONF.name )
  -- local tab = SGAD_CONF.network[ sganame ] or SGAD_CONF.grid[ sganame ]
  -- if not tab then
  --    verbose:error( "\n\nNo configuration found for host: "..tostring(SGAD_CONF.name).."!!!\n\n")
  --    os.exit(0)
  -- end

  -- -- Se não for um grid, obtém a configuração de node[1].
  -- if not tab.grid then
  --   tab = tab[1]
  -- else
  --   -- O grid padrão é o PBS (torque).
  --   tab.loadlib = tab.loadlib or "torquePBS"
  -- end
  -- local map = SGAD_CONF.platform_mapping
  -- SGAD_CONF.platform_os = tab.platform_os or (tab.platform_id and
  --   (map[tab.platform_id] or tab.platform_id))

  -- if not SGA_DAEMON:openLib() then
  --   print("Não tem a lib definida.")
  -- end
  -- SGA_DAEMON:setNodes()
-- até aqui

SGAD_CONF.restarthour = tonumber(os.getenv("RESTARTHOUR") or "")
if not SGAD_CONF.restarthour  or
   SGAD_CONF.restarthour > 23 or
   SGAD_CONF.restarthour < 0  then
   SGAD_CONF.restarthour = nil
end

-- endereço de localização do Servidor (via corbaloc)
SGAD_CONF.ssi_corbaloc = "corbaloc::"..
   SGAD_CONF.ssi_host..":"..SGAD_CONF.ssi_port..
   "/SGAMgr"..
   "/SGAMgrPOA/"..
   "SGAManager"

SGAD_CONF.ssi_ior_file = "ssi_ior"

-- Nome do arquivo para dump de comandos
SGAD_CONF.dump_file = "./commands/"..SGAD_CONF.name

-- Diretório do binário do SGA
local sgabindir = os.getenv("SGAD_DIR")
SGAD_CONF.sgabindir = sgabindir or
  string.format("%s/../bin/%s/", SGAD_CONF.path, SGAD_CONF.platform_os)

SGAD_CONF.ssibindir = SGAD_CONF.ssi_bin_directory and
  (SGAD_CONF.ssi_bin_directory .. SGAD_CONF.platform_os)

CSFS.command = [[ cd ../csfs && ./startCSFS ]]
CSFS.process_id = "CSFS_PROCESS"
-- CSFS.log_dir = ""
-- if SGAD_CONF.csfs then
--   CSFS.properties = SGAD_CONF.csfs.properties or {}
--   CSFS.launch_daemon = SGAD_CONF.csfs.launch_daemon
--   CSFS.use_local_root_directories = SGAD_CONF.csfs.use_local_root_directories
--   CSFS.retries_number = SGAD_CONF.csfs_retries_number
-- else
--   CSFS.properties = {}
-- end

-- local logdir = os.getenv("SGALOG_DIR")
-- if logdir then
--   local logname = "csfs-" ..SGAD_CONF.name..".log"
--   -- CSFS.properties.SERVER_LOG = "../src/"..logdir.."/"..logname
--   CSFS.properties.SERVER_LOG = logname
-- end
-- CSFS.properties.HOST = CSFS.properties.HOST or
--   (CSFS.launch_daemon and SGAD_CONF.localhost..SGAD_CONF.domain)

-- local iperfbindir = string.format("../bin/%s", SGAD_CONF.platform_os)
-- IPERF.command = " cd "..iperfbindir.." && ./iperf -s "
-- IPERF.process_id = "IPERF_PROCESS"

-------------------------------------------------------------------------
