/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.InstantiatingComponentAdapter;
import org.picocontainer.defaults.LifecycleStrategy;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.defaults.PicoInvocationTargetInitializationException;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class SetterInjectionComponentAdapter
extends InstantiatingComponentAdapter {
    private transient InstantiatingComponentAdapter.Guard instantiationGuard;
    private transient List setters;
    private transient List setterNames;
    private transient Class[] setterTypes;

    public SetterInjectionComponentAdapter(Object object, Class clazz, Parameter[] parameterArray, boolean bl, ComponentMonitor componentMonitor, LifecycleStrategy lifecycleStrategy) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        super(object, clazz, parameterArray, bl, componentMonitor, lifecycleStrategy);
    }

    public SetterInjectionComponentAdapter(Object object, Class clazz, Parameter[] parameterArray, boolean bl, ComponentMonitor componentMonitor) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        super(object, clazz, parameterArray, bl, componentMonitor);
    }

    public SetterInjectionComponentAdapter(Object object, Class clazz, Parameter[] parameterArray, boolean bl) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        super(object, clazz, parameterArray, bl);
    }

    public SetterInjectionComponentAdapter(Object object, Class clazz, Parameter[] parameterArray) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        this(object, clazz, parameterArray, false);
    }

    protected Constructor getGreediestSatisfiableConstructor(PicoContainer picoContainer) throws PicoIntrospectionException, UnsatisfiableDependenciesException, AmbiguousComponentResolutionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Constructor constructor = this.getConstructor();
        this.getMatchingParameterListForSetters(picoContainer);
        return constructor;
    }

    private Constructor getConstructor() throws PicoInvocationTargetInitializationException {
        Object t = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return SetterInjectionComponentAdapter.this.getComponentImplementation().getConstructor(null);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return new PicoInvocationTargetInitializationException(noSuchMethodException);
                }
                catch (SecurityException securityException) {
                    return new PicoInvocationTargetInitializationException(securityException);
                }
            }
        });
        if (t instanceof Constructor) {
            return (Constructor)t;
        }
        throw (PicoInitializationException)t;
    }

    private Parameter[] getMatchingParameterListForSetters(PicoContainer picoContainer) throws PicoInitializationException, UnsatisfiableDependenciesException {
        if (this.setters == null) {
            this.initializeSetterAndTypeLists();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(Collections.nCopies(this.setters.size(), null));
        HashSet<Integer> hashSet = new HashSet<Integer>();
        Parameter[] parameterArray = this.parameters != null ? this.parameters : this.createDefaultParameters(this.setterTypes);
        for (int i = 0; i < parameterArray.length; ++i) {
            Parameter parameter = parameterArray[i];
            boolean bl = true;
            for (int j = 0; j < this.setterTypes.length; ++j) {
                if (arrayList.get(j) != null || !parameter.isResolvable(picoContainer, this, this.setterTypes[j])) continue;
                arrayList.set(j, parameter);
                bl = false;
                break;
            }
            if (!bl) continue;
            hashSet.add(new Integer(i));
        }
        HashSet<Class> hashSet2 = new HashSet<Class>();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get(i) != null) continue;
            hashSet2.add(this.setterTypes[i]);
        }
        if (hashSet2.size() > 0) {
            throw new UnsatisfiableDependenciesException(this, hashSet2, picoContainer);
        }
        if (hashSet.size() > 0) {
            throw new PicoInitializationException("Following parameters do not match any of the setters for " + this.getComponentImplementation() + ": " + ((Object)hashSet).toString());
        }
        return arrayList.toArray(new Parameter[arrayList.size()]);
    }

    public Object getComponentInstance(PicoContainer picoContainer) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        final Constructor constructor = this.getConstructor();
        if (this.instantiationGuard == null) {
            this.instantiationGuard = new InstantiatingComponentAdapter.Guard(){

                public Object run() {
                    Object object;
                    Parameter[] parameterArray = SetterInjectionComponentAdapter.this.getMatchingParameterListForSetters(this.guardedContainer);
                    ComponentMonitor componentMonitor = SetterInjectionComponentAdapter.this.currentMonitor();
                    try {
                        long l = System.currentTimeMillis();
                        componentMonitor.instantiating(constructor);
                        object = SetterInjectionComponentAdapter.this.newInstance(constructor, null);
                        componentMonitor.instantiated(constructor, System.currentTimeMillis() - l);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        componentMonitor.instantiationFailed(constructor, invocationTargetException);
                        if (invocationTargetException.getTargetException() instanceof RuntimeException) {
                            throw (RuntimeException)invocationTargetException.getTargetException();
                        }
                        if (invocationTargetException.getTargetException() instanceof Error) {
                            throw (Error)invocationTargetException.getTargetException();
                        }
                        throw new PicoInvocationTargetInitializationException(invocationTargetException.getTargetException());
                    }
                    catch (InstantiationException instantiationException) {
                        componentMonitor.instantiationFailed(constructor, instantiationException);
                        throw new PicoInitializationException("Should never get here");
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        componentMonitor.instantiationFailed(constructor, illegalAccessException);
                        throw new PicoInitializationException(illegalAccessException);
                    }
                    Method method = null;
                    try {
                        for (int i = 0; i < SetterInjectionComponentAdapter.this.setters.size(); ++i) {
                            method = (Method)SetterInjectionComponentAdapter.this.setters.get(i);
                            componentMonitor.invoking(method, object);
                            long l = System.currentTimeMillis();
                            method.invoke(object, parameterArray[i].resolveInstance(this.guardedContainer, SetterInjectionComponentAdapter.this, SetterInjectionComponentAdapter.this.setterTypes[i]));
                            componentMonitor.invoked(method, object, System.currentTimeMillis() - l);
                        }
                        return object;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        componentMonitor.invocationFailed(method, object, invocationTargetException);
                        if (invocationTargetException.getTargetException() instanceof RuntimeException) {
                            throw (RuntimeException)invocationTargetException.getTargetException();
                        }
                        if (invocationTargetException.getTargetException() instanceof Error) {
                            throw (Error)invocationTargetException.getTargetException();
                        }
                        throw new PicoInvocationTargetInitializationException(invocationTargetException.getTargetException());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        componentMonitor.invocationFailed(method, object, illegalAccessException);
                        throw new PicoInvocationTargetInitializationException(illegalAccessException);
                    }
                }
            };
        }
        this.instantiationGuard.setArguments(picoContainer);
        return this.instantiationGuard.observe(this.getComponentImplementation());
    }

    public void verify(final PicoContainer picoContainer) throws PicoIntrospectionException {
        if (this.verifyingGuard == null) {
            this.verifyingGuard = new InstantiatingComponentAdapter.Guard(){

                public Object run() {
                    Parameter[] parameterArray = SetterInjectionComponentAdapter.this.getMatchingParameterListForSetters(this.guardedContainer);
                    for (int i = 0; i < parameterArray.length; ++i) {
                        parameterArray[i].verify(picoContainer, SetterInjectionComponentAdapter.this, SetterInjectionComponentAdapter.this.setterTypes[i]);
                    }
                    return null;
                }
            };
        }
        this.verifyingGuard.setArguments(picoContainer);
        this.verifyingGuard.observe(this.getComponentImplementation());
    }

    private void initializeSetterAndTypeLists() {
        this.setters = new ArrayList();
        this.setterNames = new ArrayList();
        ArrayList arrayList = new ArrayList();
        Method[] methodArray = this.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            boolean bl;
            Method method = methodArray[i];
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length != 1) continue;
            String string = method.getName();
            boolean bl2 = bl = string.length() >= 4 && string.startsWith("set") && Character.isUpperCase(string.charAt(3));
            if (!bl) continue;
            String string2 = Character.toLowerCase(string.charAt(3)) + string.substring(4);
            this.setters.add(method);
            this.setterNames.add(string2);
            arrayList.add(classArray[0]);
        }
        this.setterTypes = arrayList.toArray(new Class[0]);
    }

    private Method[] getMethods() {
        return (Method[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return SetterInjectionComponentAdapter.this.getComponentImplementation().getMethods();
            }
        });
    }
}

