/*
 * Decompiled with CFR 0.152.
 */
package csfs.datatransfer.streamblockingnio;

import csfs.datatransfer.DataTransferMethod;
import csfs.datatransfer.streamblockingnio.StreamBlockingNIOSenderThread;
import csfs.impl.util.IDGenerator;
import csfs.impl.util.SystemProperties;
import csfs.impl.util.Util;
import csfs.remote.InvalidStateException;
import csfs.remote.NotFileException;
import csfs.remote.RemoteFile;
import csfs.remote.ServerException;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.HashMap;

public class StreamBlockingNIOMethod
implements DataTransferMethod {
    private HashMap<Long, Integer> activeCopies = new HashMap();

    public synchronized void notifyThreadEnd(StreamBlockingNIOSenderThread thread) {
        Long key = new Long(thread.getCopyID());
        if (thread.getResponse()) {
            int activeCount = this.activeCopies.get(key);
            if (--activeCount == 0) {
                this.activeCopies.remove(key);
                this.notifyAll();
            } else {
                this.activeCopies.put(key, new Integer(activeCount));
            }
        } else {
            System.out.println("COPY FAILED!!!" + thread.getFilename());
        }
    }

    @Override
    public synchronized boolean copy(File localFile, RemoteFile destination, String method) throws NotFileException, InvalidStateException, ServerException {
        int i;
        long expectedBytesPerChannel;
        boolean response = false;
        if (destination.isDirectory()) {
            throw new NotFileException(destination.getFullName());
        }
        int indexMethod = method.indexOf(45);
        int numChannels = Integer.parseInt(method.substring(indexMethod + 1));
        String nioAddress = destination.getFileServer().getCopyServerAddress(method.substring(0, indexMethod));
        int index = nioAddress.lastIndexOf(58);
        String host = nioAddress.substring(0, index);
        int port = Integer.parseInt(nioAddress.substring(index + 1));
        InetSocketAddress nio = new InetSocketAddress(host, port);
        long size = localFile.length();
        long realBytesPerChannel = expectedBytesPerChannel = size / (long)numChannels;
        StreamBlockingNIOSenderThread[] threads = new StreamBlockingNIOSenderThread[numChannels];
        long copyId = IDGenerator.nextId();
        String targetFilename = Util.stringArrayToString(destination.getFullName());
        for (int i2 = 0; i2 < threads.length; ++i2) {
            if (i2 == threads.length - 1) {
                realBytesPerChannel = size - expectedBytesPerChannel * (long)i2;
            }
            threads[i2] = new StreamBlockingNIOSenderThread(nio, localFile, expectedBytesPerChannel * (long)i2, realBytesPerChannel, targetFilename, copyId, this);
        }
        Long key = new Long(copyId);
        this.activeCopies.put(key, new Integer(numChannels));
        for (i = 0; i < threads.length; ++i) {
            threads[i].start();
        }
        while (this.activeCopies.get(key) != null) {
            try {
                this.wait();
            }
            catch (InterruptedException exc) {
                exc.printStackTrace();
            }
        }
        response = true;
        for (i = 0; i < threads.length; ++i) {
            response = response && threads[i].getResponse();
        }
        return response;
    }

    @Override
    public String getName() {
        return "STREAM_BLOCKING_NIO";
    }

    @Override
    public String getDetailedInfo() {
        return "MULTI_STREAM_BLOCKING_NIO NUM_CHANNELS=" + SystemProperties.getProperty("NUM_CHANNELS");
    }
}

