/*
 * Decompiled with CFR 0.152.
 */
package csfs.datatransfer.streamblockingnio;

import csfs.datatransfer.streamblockingnio.StreamBlockingNIOReceiverThread;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import java.util.logging.Logger;

public class StreamBlockingNIOServer
extends Thread {
    private String rootDir;
    private int port;

    public StreamBlockingNIOServer(String rootDir, int port) {
        this.rootDir = rootDir;
        this.port = port;
    }

    @Override
    public void run() {
        try {
            ServerSocket server = ServerSocketChannel.open().socket();
            String localhost = InetAddress.getLocalHost().getHostName();
            server.bind(new InetSocketAddress(localhost, this.port));
            Logger.global.info("NIOCopyServer BOUND TO:" + this.port);
            while (true) {
                Socket socket = server.accept();
                StreamBlockingNIOReceiverThread t = new StreamBlockingNIOReceiverThread(socket, this.rootDir);
                t.setPriority(this.getPriority() - 1);
                t.start();
            }
        }
        catch (BindException exc) {
            Logger.global.severe("NIOCopyServer DID NOT start at this process!!! SOMETHING WAS ALREADY BOUND!!!");
        }
        catch (IOException exc) {
            Logger.global.severe("NIOCopyServer SHUT DOWN!");
            exc.printStackTrace();
        }
    }
}

