// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------


#include "wioapiimpl.h"

// using namespace std;
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

WIOFile::~WIOFile() {
}


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

// ............................................................................
/**
 *
 */
WIOFileImpl::WIOFileImpl(wio::WIOFile* wioFile) throw (wioapi::Exception*) {
   if (wioFile == NULL) {
      throw new wioapi::Exception("WIOFile::WIOFile()", 
            "Ponteiro nulo passado ao construtor!", "");
   }
   this->wioFile = wioFile;
}

// ............................................................................
/**
 * O ObjVar deleta os atributos devidamente. No se deve fazer [delete] aqui.
 */
WIOFileImpl::~WIOFileImpl() {
   destroy();
}

// ............................................................................
/**
 *
 */
char* WIOFileImpl::whoCreated(void) const throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFile.in())) {
      throw new wioapi::Exception("WIOFile::whoCreated()", 
            "Objeto CORBA nulo detectado!", "");
   }
   _TRY(return wioFile->whoCreated(), "WIOFile::whoCreated");
}

// ............................................................................
/**
 *
 */
WIODateTimeInfo* WIOFileImpl::creationTime(void) const 
throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFile.in())) {
      throw new wioapi::Exception("WIOFile::lastModificationTime()",
            "Objeto CORBA nulo detectado!", "");
   }

   wio::WIODateTimeInfo dt;
   _TRY(
      dt = wioFile->lastModificationTime(),
      "WIOFileSystem::lastModificationTime"
   );

   wioapi::WIODateTimeInfo* info = new wioapi::WIODateTimeInfo(
         dt.day, dt.month, dt.year, 
         dt.hour, dt.minute, dt.second);
   return info;
}

// ............................................................................
/**
 *
 */
WIODateTimeInfo* WIOFileImpl::lastModificationTime(void) const
throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFile.in())) {
      throw new wioapi::Exception("WIOFile::lastModificationTime()",
            "Objeto CORBA nulo detectado!", "");
   }

   wio::WIODateTimeInfo dt;
   _TRY(
      dt = wioFile->lastModificationTime(),
      "WIOFileSystem::lastModificationTime"
   );

   wioapi::WIODateTimeInfo* info = new wioapi::WIODateTimeInfo(
         dt.day, dt.month, dt.year, 
         dt.hour, dt.minute, dt.second);
   return info;
}

// ............................................................................
/**
 *
 */
char* WIOFileImpl::getPath(void) const throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFile.in())) {
      throw new wioapi::Exception("WIOFile::getPath()", 
            "Objeto CORBA nulo detectado!", "");
   }
   _TRY(return wioFile->getPath(), "WIOFile::getPath");
}

// ............................................................................
/**
 *
 */
WIOFile* WIOFileImpl::getParent(void) const throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFile.in())) {
      throw new wioapi::Exception("WIOFile::getParent()", 
            "Objeto CORBA nulo detectado!", "");
   }
   _TRY(
      return new WIOFileImpl(wioFile->getParent()), 
      "WIOFile::getParent"
   );
}

// ............................................................................
/**
 *
 */
WIOProject* WIOFileImpl::getProject(void) const throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFile.in())) {
      throw new wioapi::Exception("WIOFile::getProject()", 
            "Objeto CORBA nulo detectado!", "");
   }
   _TRY(
      return new WIOProjectImpl(wioFile->getProject()), 
      "WIOFile::getProject"
   );
}

// ............................................................................
/**
 *
 */
bool WIOFileImpl::isUnderConstruction(void) const throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFile.in())) {
      throw new wioapi::Exception("WIOFile::isUnderConstruction()", 
            "Objeto CORBA nulo detectado!", "");
   }
   _TRY(return booleanToBool(wioFile->isUnderConstruction()), "WIOFile::isUnderConstruction");
}

// ............................................................................
/**
 *
 */
bool WIOFileImpl::isPublished(void) const throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFile.in())) {
      throw new wioapi::Exception("WIOFile::isPublished()", 
            "Objeto CORBA nulo detectado!", "");
   }
   _TRY(return booleanToBool(wioFile->isPublished()), "WIOFile::isPublished");
}

// ............................................................................
/**
 *
 */
bool WIOFileImpl::canRead(void) const throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFile.in())) {
      throw new wioapi::Exception("WIOFile::canRead()", 
            "Objeto CORBA nulo detectado!", "");
   }
   _TRY(return booleanToBool(wioFile->canRead()), "WIOFile::canRead");
}

// ............................................................................
/**
 *
 */
bool WIOFileImpl::canWrite(void) const throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFile.in())) {
      throw new wioapi::Exception("WIOFile::canWrite()", 
            "Objeto CORBA nulo detectado!", "");
   }
   _TRY(return booleanToBool(wioFile->canWrite()), "WIOFile::canWrite");
}

// ............................................................................
/**
 *
 */
WIOFileMode WIOFileImpl::getMode(void) const throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFile.in())) {
      throw new wioapi::Exception("WIOFile::getMode()", 
            "Objeto CORBA nulo detectado!", "");
   }
   _TRY(return (WIOFileMode)(wioFile->getMode()), "WIOFile::getMode");
}

// ............................................................................
/**
 *
 */
bool WIOFileImpl::isDirectory(void) const throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFile.in())) {
      throw new wioapi::Exception("WIOFile::isDirectory()", 
            "Objeto CORBA nulo detectado!", "");
   }
   _TRY(return booleanToBool(wioFile->isDirectory()), "WIOFile::isDirectory");
}

// ............................................................................
/**
 *
 */
char* WIOFileImpl::getFileType(void) const throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFile.in())) {
      throw new wioapi::Exception("WIOFile::getFileType()", 
            "Objeto CORBA nulo detectado!", "");
   }
   _TRY(return wioFile->getFileType(), "WIOFile::getFileType");
}

// ............................................................................
/**
 *
 */
long WIOFileImpl::getNumFiles(void) const throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFile.in())) {
      throw new wioapi::Exception("WIOFile::getNumFiles()", 
            "Objeto CORBA nulo detectado!", "");
   }
   _TRY(return wioFile->getNumFiles(), "WIOFile::getNumFiles");
}

// ............................................................................
/**
 *
 */
char* WIOFileImpl::getDescription(void) const throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFile.in())) {
      throw new wioapi::Exception("WIOFile::getDescription()", 
            "Objeto CORBA nulo detectado!", "");
   }
   _TRY(return (wioFile->getDescription()), "WIOFile::getDescription");
}

// ............................................................................
/**
 *
 */
void WIOFileImpl::setDescription(const char* desc) 
const throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFile.in())) {
      throw new wioapi::Exception("WIOFile::setDescription()", 
            "Objeto CORBA nulo detectado!", "");
   }
   _TRY((wioFile->setDescription(desc)), "WIOFile::setDescription");
}

// ............................................................................
/**
 *
 */
void WIOFileImpl::appendDescription(const char* desc) 
const throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFile.in())) {
      throw new wioapi::Exception("WIOFile::appendDescription()", 
            "Objeto CORBA nulo detectado!", "");
   }
   _TRY((wioFile->appendDescription(desc)), "WIOFile::appendDescription");
}

// ............................................................................
/**
 *
 */
WIOFile* WIOFileImpl::getFile(long i) const throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFile.in())) {
      throw new wioapi::Exception("WIOFile::getFile()", 
            "Objeto CORBA nulo detectado!", "");
   }

   if (i >= wioFile->getNumFiles()) {
      throw new wioapi::Exception("WIOFile::getFile()", 
            "ndice alm do permitido!", "");
   }

   _TRY(return new WIOFileImpl(wioFile->getFile(i)), "WIOFile::getFile");
}

// ............................................................................
/**
 *
 */
void WIOFileImpl::open(WIOFileMode mode) throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFile.in())) {
      throw new wioapi::Exception("WIOFile::open()", 
            "Objeto CORBA nulo detectado!", "");
   }

   _TRY(wioFile->open((wio::WIOFileMode)mode), "WIOFile::open");
}

// ............................................................................
/**
 *
 */
void WIOFileImpl::close(void) throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFile.in())) {
      throw new wioapi::Exception("WIOFile::close()", 
            "Objeto CORBA nulo detectado!", "");
   }
   _TRY(wioFile->close(), "WIOFile::close");
}

// ............................................................................
/**
 *
 */
static void* get_read_pointer(char* app_buffer, void* read_buffer, 
long offset) {
#ifdef ORBACUS
    CORBA::Octet* app_pointer = (CORBA::Octet*)(app_buffer+offset);
    return app_pointer;
#else
    return read_buffer;
#endif
}

// ............................................................................
/**
 *
 */
static void destroy_read_buffer(void* buffer) {
#ifdef ORBACUS
#else
   free(buffer);
#endif
}

// ............................................................................
/**
 *
 */
static void* create_read_buffer(void* app_buffer, long chunk) {
#ifdef ORBACUS
   return app_buffer;
#else
   return malloc(chunk);
#endif
}

// ............................................................................
/**
 *
 */
static void copy_buffer(void* dst, void* src, long len) {
#ifdef ORBACUS
#else
   if (len > 0) memcpy(dst, src, len);
#endif
}

// ............................................................................
/**
 *
 */
long WIOFileImpl::read(long size, char* app_buffer, long chunk) const
throw (wioapi::Exception*) {
   // Instrumentao
   if (CORBA::is_nil (wioFile.in())) {
      throw new wioapi::Exception("WIOFile::read()", 
            "Objeto CORBA nulo detectado!", "");
   }
   
   // se o chunk  especificado como 0, usamos um valor default
   chunk = (chunk <= 0 ? size : chunk);
   chunk = (chunk > size ? size : chunk);

   // Caso o usurio no tenha fornecido um buffer,  gerada uma mensagem
   // de log e retorna-se da funo. 
   if (app_buffer == NULL) {
      cout << "WIOFile::read() - NULL buffer assigned to function!\n"; 
      return 0;
   }
   
   // Alocao de um pseudo buffer de leitura.
   void* read_buffer = create_read_buffer(app_buffer, chunk);
   if (read_buffer == NULL) {
      cout << "WIOFile::read() - Unable to allocate a read buffer!\n"; 
      return 0;
   }

   try {
    long nbytes = 0;
    for (int i = 0; i < size; i += chunk) {
        long expected = minLong(size-i, chunk);
        long offset = i;
        
        // Ponteiro para a rea final da aplicao.
        CORBA::Octet* app_pointer = (CORBA::Octet*)(app_buffer+offset);

        // Ponteiro temporrio para criao da estrutura byte, que
        // pode ser otimizado para a prpria rea da aplicao.
        void* ptaux = get_read_pointer(app_buffer, read_buffer, offset);
        
        // Envia-se um nico byte esprio para usarmos o get_buffer()
        // que no MICO precisa ter necessariamente um elemento.
        wio::Bytes bytes(expected, 1, (CORBA::Octet*)ptaux, false);
        long len = wioFile->read(expected, bytes);

        // Cpia para a rea da aplicao.
        copy_buffer(app_pointer,(void*)bytes.get_buffer(), len);

        // Caso o tamanho lido seja diferente do esperado, assume-se que
        // o arquivo terminou ou houve erro de leitura.
        if (len != expected) {
           if (len < 0) cout << "WIOFile::read() - Failure #" << len << "!\n"; 
           else nbytes = i+len;
           destroy_read_buffer(read_buffer);
           return nbytes;
        }
    }
    destroy_read_buffer(read_buffer);
    return size;
  }
  catch (wio::WIOServiceException& wse) { 
     cerr << wse << "\n";
     char* server_msg = wse.message; 
     throw new wioapi::Exception("WIOFile::read()", "", server_msg); 
  } 
  catch(CORBA::Exception& ex) {
     cerr << ex << "\n";
     throw new wioapi::Exception("WIOFile::read()", "", 
         "Exceo CORBA detectada (sem informaes do servidor)");
  }
  catch (...) { 
     throw new wioapi::Exception("WIOFile::read()", 
         "Exceo genrica local detectada (client-side)", ""); 
  }

}

// ............................................................................
/**
 *
 */
long long WIOFileImpl::size(void) const throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFile.in())) {
      throw new wioapi::Exception("WIOFile::size()", 
            "Objeto CORBA nulo detectado!", "");
   }
   _TRY(return wioFile->size(), "WIOFile::size()");
}

// ............................................................................
/**
 *
 */
void WIOFileImpl::resize(long long size) throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFile.in())) {
      throw new wioapi::Exception("WIOFile::resize()", 
            "Objeto CORBA nulo detectado!", "");
   }
   _TRY(wioFile->resize(size), "WIOFile::resize()");
}

// ............................................................................
/**
 *
 */
long WIOFileImpl::write(const char* content, long size, long chunk) 
throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFile.in())) {
      throw new wioapi::Exception("WIOFile::write()", 
            "Objeto CORBA nulo detectado!", "");
   }
   
   // se o chunk  especificado como 0, usamos um valor default
   chunk = chunk <= 0 ? size : chunk;
   try {
      for (int i=0; i < size; i += chunk) {
         // Se a escrita por chunk ultrapassar o tamanho pedido, truncamo-na.
         wio::Bytes bytes(chunk, minLong(size-i, chunk), 
               (CORBA::Octet*) (content+i), false);
         long len = wioFile->write(bytes);
         if (len != minLong(size - i, chunk)) return i + len;         
      }
      return size;
   }
  catch (wio::WIOServiceException& wse) { 
     cerr << wse << "\n";
     char* server_msg = wse.message; 
     throw new wioapi::Exception("WIOFile::write()", "", server_msg); 
  } 
  catch(CORBA::Exception& ex) {
     cerr << ex << "\n";
     throw new wioapi::Exception("WIOFile::write()", "",
         "Exceo CORBA detectada (sem informaes do servidor)");
  }
  catch (...) { 
     throw new wioapi::Exception("WIOFile::write()", 
         "Exceo local detectada (client-side)", ""); 
  }
}

// ............................................................................
/**
 *
 */
void WIOFileImpl::destroy(void) throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFile.in())) {
      throw new wioapi::Exception("WIOFile::destroy()", 
            "Objeto CORBA nulo detectado!", "");
   }
   _TRY(wioFile->destroy(), "WIOFile::destroy()");
}

// ............................................................................
/**
 *
 */
void WIOFileImpl::seek(long long offset, SeekType type) throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFile.in())) {
      throw new wioapi::Exception("WIOFile::seek()", 
            "Objeto CORBA nulo detectado!", "");
   }
   _TRY(wioFile->seek(offset, (wio::SeekType)type), "WIOFile::seek()");
}

// ............................................................................
/**
 *
 */
long long WIOFileImpl::tell(void) const throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFile.in())) {
      throw new wioapi::Exception("WIOFile::tell()", 
            "Objeto CORBA nulo detectado!", "");
   }
   _TRY(return wioFile->tell(), "WIOFile::tell()");
}

// ............................................................................
/**
 *
 */
bool WIOFileImpl::eof(void) const throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFile.in())) {
      throw new wioapi::Exception("WIOFile::eof()", 
            "Objeto CORBA nulo detectado!", "");
   }
   _TRY(return booleanToBool(wioFile->eof()), "WIOFile::eof()");
}
