package csdk.v1_0.api.application;

/**
 * Mensagem utilizada na comunicao entre aplicaes.
 */
public interface IMessage {

  /**
   * O identificador padro de mensagens do tipo "arquivo de projeto" para
   * aplicaes CSDK. O valor da mensagem deve ser um array de strings com o
   * caminho para o arquivo de projeto.
   */
  public static final String PROJECT_FILE_PATH_MESSAGE = "PROJECT_FILE_PATH";

  /**
   * O identificador padro de mensagens do tipo "arquivo local" para aplicaes
   * CSDK. O valor da mensagem deve ser um array de strings com o caminho para o
   * arquivo local.
   */
  public static final String LOCAL_FILE_PATH_MESSAGE = "LOCAL_FILE_PATH";

  /**
   * Obtm o tipo da mensagem.
   * 
   * @return o tipo da mensagem.
   */
  public String getType();

  /**
   * Obtm o valor da mensagem.
   * 
   * @return o valor da mensagem.
   */
  public Object getValue();

}
