package csdk.v1_0.api.filesystem;

import java.awt.Window;

/**
 * Representa um lock de um {@link IFile arquivo}.
 */
public interface IFileLock {

  /**
   * Indica o tipo de lock obtido para um determinado arquivo.
   */
  public enum LockStatus {
    /**
     * Lock exclusivo
     */
    LOCK_EXCLUSIVE,
    /**
     * No foi possvel obter lock para o arquivo.
     */
    LOCK_DENIED,
    /**
     * Lock compartilhado
     */
    LOCK_SHARED,
    /**
     * Pedido do lock foi removido
     */
    LOCK_RELEASED
  }

  /**
   * Obtm o status do lock do arquivo
   * 
   * @return o status do lock do arquivo
   */
  public LockStatus getLockStatus();

  /**
   * Remove o lock do arquivo se tem o lock compartilhado ou exclusivo.
   * 
   * @param window janela pai para a ao.
   */
  public void releaseLock(Window window);

}
