package csdk.v2.helper.application;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Locale;

import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

/**
 * Ao genrica de exibio de about.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ApplicationAboutAction extends
  AbstractWindowApplicationAction<AbstractApplication> {

  /**
   * Construtor padro.
   * 
   * @param application a aplicao.
   * @param frame janela-me da ao.
   */
  public ApplicationAboutAction(AbstractApplication application, Window frame) {
    super(application, frame);
    Locale locale = application.getLocale();
    String label = HelperBundle.getString(locale, getClass(), "name");
    String tooltip = HelperBundle.getString(locale, getClass(), "tooltip");
    ImageIcon icon = ApplicationImages.ICON_ABOUT_16;
    setName(label);
    setTooltip(tooltip);
    setIcon(icon);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent ae) {
    AbstractApplication application = getApplication();
    String applicationId = application.getApplicationId();
    String authorName = application.getAuthor();
    String authorMail = application.getAuthorEmail();
    String versionNumber = application.getVersion();
    String applicationName = application.getApplicationName();
    String description = application.getApplicationDescription();
    StringBuilder messageBuilder = new StringBuilder();
    if (applicationName != null) {
      messageBuilder.append(applicationName);
      messageBuilder.append(" [");
      messageBuilder.append(applicationId);
      messageBuilder.append("]");
    }
    else {
      messageBuilder.append(applicationId);
    }
    if (description != null) {
      messageBuilder.append("\n");
      messageBuilder.append(description);
    }
    messageBuilder.append("\n");
    if (authorName != null) {
      messageBuilder.append("\n");
      messageBuilder.append(authorName);
    }
    if (authorMail != null) {
      messageBuilder.append("\n");
      messageBuilder.append(authorMail);
    }
    if (versionNumber != null) {
      messageBuilder.append("\n");
      messageBuilder.append(versionNumber);
    }
    ImageIcon icon = application.getApplicationIcon();
    JOptionPane.showMessageDialog(getWindow(), messageBuilder, applicationId,
      JOptionPane.INFORMATION_MESSAGE, icon);
  }
}
