package csdk.v2.helper.command.parameters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Valor de um parmetro do tipo arquivo de entrada mltiplo.
 */
public class FileListParameterValue extends AbstractParameterValue<List<URL>> {

  /**
   * Construtor.
   */
  public FileListParameterValue() {
    super(new ArrayList<>());
  }

  /**
   * Construtor.
   * 
   * @param values lista de valores de arquivo.
   */
  public FileListParameterValue(List<FileParameterValue> values) {
    super(convertToFileValue(values));
  }

  /**
   * Construtor.
   * 
   * @param values lista de valores de arquivo.
   */
  public FileListParameterValue(FileParameterValue[] values) {
    super(convertToFileValue(Arrays.asList(values)));
  }

  /**
   * Converte uma lista de valores de parmetros para a lista de descries de
   * arquivos.
   * 
   * @param fileParameterValues lista de valores de parmetro do tipo arquivo.
   * @return lista de descries de arquivo.
   */
  private static List<URL> convertToFileValue(
    List<FileParameterValue> fileParameterValues) {
    List<URL> values = new ArrayList<>();
    for (FileParameterValue fileParameterValue : fileParameterValues) {
      URL value = null;
      if (fileParameterValue != null) {
        value = fileParameterValue.getValue();
      }
      values.add(value);
    }
    return values;
  }

  /**
   * Adiciona um novo arquivo ao valor do parmetro.
   * 
   * @param path o caminho do arquivo.
   * @param type o tipo do arquivo.
   */
  public void addValue(String path, String type) {
    getValue().add(new URL(path, type));
  }

  /**
   * Adiciona um novo arquivo ao valor do parmetro.
   * 
   * @param file descrio do arquivo.
   */
  public void addValue(FileParameterValue file) {
    if (file != null) {
      URL value = file.getValue();
      getValue().add(new URL(value.getPath(), value.getType()));
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected ParameterValueConverter<List<URL>> getValueConverter() {
    return new FileListValueConverter();
  }
}
