package csdk.v2.helper.command.parameters;

import java.util.List;

/**
 * Conversor para parmetros com valor lista de arquivos..
 */
public class FileListValueConverter implements
  ParameterValueConverter<List<URL>> {

  /**
   * Caractere que separa os elementos da lista.
   */
  private static final char ELEMENT_SEPARATOR_CHAR = '|';

  /**
   * Construtor.
   */
  public FileListValueConverter() {
    super();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getValueAsString(List<URL> values)
    throws ParameterValueConvertionException {
    if (values == null || values.size() == 0) {
      return null;
    }
    URLValueConverter converter = new URLValueConverter();
    StringBuilder buffer = new StringBuilder();
    String separator = "";
    for (URL value : values) {
      buffer.append(separator);
      buffer.append(converter.getValueAsString(value));
      separator = Character.toString(ELEMENT_SEPARATOR_CHAR);
    }
    return buffer.toString();
  }

}
