package csdk.v1_0.helper.application;

import java.awt.event.ActionEvent;
import java.util.Locale;

import javax.swing.ImageIcon;

/**
 * @author Tecgraf/PUC-Rio
 */
public class ApplicationExitAction extends
  AbstractApplicationAction<AbstractApplication> {

  /**
   * Construtor padro.
   * 
   * @param application a aplicao.
   */
  public ApplicationExitAction(AbstractApplication application) {
    super(application);
    Locale locale = application.getLocale();
    String name = HelperBundle.getString(locale, getClass(), "name");
    String tooltip = HelperBundle.getString(locale, getClass(), "tooltip");
    ImageIcon icon = ApplicationImages.ICON_EXIT_16;
    setName(name);
    setTooltip(tooltip);
    setIcon(icon);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent ae) {
    AbstractApplication application = getApplication();
    application.finishApplication();
  }
}
