package csdk.v1_0.helper.application;

import csdk.v1_0.api.application.IMessage;

/**
 * Mensagem utilizada para fazer a comunicao entre aplicaes.
 */
public class Message implements IMessage {

  /**
   * Tipo da mensagem.
   */
  private final String type;

  /**
   * Valor da mensagem.
   */
  private final Object value;

  /**
   * Construtor
   * 
   * @param type tipo da mensagem
   * @param value valor da mensagem
   */
  public Message(String type, Object value) {
    this.type = type;
    this.value = value;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getType() {
    return type;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValue() {
    return value;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return value + "(" + type + ")";
  }

}
