package csdk.v1_0.helper.command;

import java.util.Map;

import csdk.v1_0.api.command.IAlgorithmTemplate;

/**
 * Essa classe representa os valores dos paramtros de um n (algoritmo) do
 * fluxo, que devem ser preenchidos previamente, sem a interferncia do usurio.
 * 
 * @author pizzol
 * 
 */
public class AlgorithmTemplate implements IAlgorithmTemplate {
  /** Nome do algoritmo que representa um n */
  private final String algorithmName;

  /** Identificador da verso do algoritmo que representa um n */
  private final String algorithmVersionId;

  /** Mapeamento dos parmetros do n e seus valores */
  private final Map<String, String> parameterValues;

  /**
   * Obtm o nome do algoritmo.
   * 
   * @return o nome do algoritmo
   */
  @Override
  public String getAlgorithmName() {
    return algorithmName;
  }

  /**
   * Obtm o identificador da verso do algoritmo.
   * 
   * @return o identificador da verso do algoritmo
   */
  @Override
  public String getAlgorithmVersionId() {
    return algorithmVersionId;
  }

  /**
   * Adiciona um valor a um determinado parmetro do algoritmo.
   * 
   * @param parameterName nome do parmetro do algoritmo
   * @param parameterValue valor do parmetro
   */
  public void addParameterValue(String parameterName, String parameterValue) {
    parameterValues.put(parameterName, parameterValue);
  }

  /**
   * Obtm todos os valores dos parmetros do algoritmo que foram preenchidos.
   * 
   * @return um mapa com todos os parmetros preenchidos e seus respectivos
   *         valores
   */
  @Override
  public Map<String, String> getParametersValues() {
    return parameterValues;
  }

  /**
   * Construtor.
   * 
   * @param algorithmName nome do algoritmo.
   * @param algorithmVersionId identificador da verso do algoritmo.
   * @param parameterValues Mapa com os valores dos parmetros do algoritmo.
   */
  public AlgorithmTemplate(String algorithmName, String algorithmVersionId,
    Map<String, String> parameterValues) {
    this.algorithmName = algorithmName;
    this.algorithmVersionId = algorithmVersionId;
    this.parameterValues = parameterValues;
  }

}
