package csdk.v2.rest.helper;

import csdk.v2.api.application.IApplication;

/**
 * Base para a implementao de interfaces de aplicativos.
 *
 * @param <A> classe de aplicao.
 *
 * @author Tecgraf/PUC-Rio
 */
public class ApplicationInterface <A extends IApplication> {

  /**
   * Aplicao.
   */
  private final A application;

  /**
   * Construtor
   *
   * @param application aplicao.
   */
  public ApplicationInterface(A application) {
    this.application = application;
  }

  /**
   * Consulta a aplicao.
   *
   * @return aplicao
   */
  public A getApplication() {
    return application;
  }

}
