package csdk.v2.rest.helper.exception;

import javax.ws.rs.core.Response;

/**
        * Base para a implementao de excees REST
        *
        * @author Tecgraf/PUC-Rio
        */
public class RESTException extends Exception {
    /**
     * Codigo de erro que deve ser retornado como resposta a rquisio
     */
    private Response.Status status;


    /**
     * Construtor da exceo
     *
     * @param message Mensagem de erro
     * @param cause Causa da exceo
     * @param code O cdigo de erro levantado
     */
    public RESTException(String message, Throwable cause, Response.Status code) {
        super(message, cause);
        this.status = code;
    }

    /**
     * Construtor da exceo sem causa
     *
     * @param message Mensagem de erro
     * @param code Cdigo de erro levantado
     */
    public RESTException(String message, Response.Status code) {
        super(message);
        this.status = code;
    }

    /**
     * Recupera o codigo de erro
     *
     * @return o cdigo de erro
     */
    public Response.Status getStatus() {
        return status;
    }
}
