/*
 * Decompiled with CFR 0.152.
 */
package csdk.v1_0.helper;

import csdk.v1_0.api.application.ApplicationException;
import csdk.v1_0.api.core.ICSDKEnvironment;
import csdk.v1_0.helper.AbstractCSDKApplication;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public abstract class AbstractCSDKWindowApplication
extends AbstractCSDKApplication {
    private JFrame applicationFrame;
    private final ArrayList<Window> dependentWindows = new ArrayList();
    private WindowCloseListener windowCloseListener;

    public AbstractCSDKWindowApplication(ICSDKEnvironment csdkInterface) {
        super(csdkInterface);
        this.applicationFrame = new JFrame();
        this.applicationFrame.setDefaultCloseOperation(0);
        this.windowCloseListener = new WindowCloseListener();
        this.applicationFrame.addWindowListener(this.windowCloseListener);
    }

    @Override
    public final void onApplicationStart() throws ApplicationException {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    ImageIcon icon = AbstractCSDKWindowApplication.this.getSmallApplicationIcon();
                    if (icon != null) {
                        AbstractCSDKWindowApplication.this.applicationFrame.setIconImage(icon.getImage());
                    }
                    AbstractCSDKWindowApplication.this.applicationFrame.setTitle(AbstractCSDKWindowApplication.this.getApplicationName());
                    AbstractCSDKWindowApplication.this.applicationStarted(AbstractCSDKWindowApplication.this.applicationFrame);
                    AbstractCSDKWindowApplication.this.applicationFrame.setVisible(true);
                }
                catch (Exception e) {
                    AbstractCSDKWindowApplication.this.handleException(e, AbstractCSDKWindowApplication.this.applicationFrame);
                }
            }
        };
        this.invoke(runnable);
    }

    protected abstract void applicationStarted(JFrame var1) throws ApplicationException;

    protected abstract void applicationEnded() throws ApplicationException;

    @Override
    public final void onApplicationEnd() throws ApplicationException {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AbstractCSDKWindowApplication.this.applicationEnded();
                    AbstractCSDKWindowApplication.this.closeDependentWindows();
                }
                catch (Exception e) {
                    AbstractCSDKWindowApplication.this.handleException(e, AbstractCSDKWindowApplication.this.applicationFrame);
                }
                finally {
                    if (AbstractCSDKWindowApplication.this.applicationFrame != null) {
                        AbstractCSDKWindowApplication.this.applicationFrame.removeWindowListener(AbstractCSDKWindowApplication.this.windowCloseListener);
                        AbstractCSDKWindowApplication.this.windowCloseListener = null;
                        AbstractCSDKWindowApplication.this.applicationFrame.dispose();
                        AbstractCSDKWindowApplication.this.applicationFrame = null;
                    }
                    AbstractCSDKWindowApplication.this.disposeContexts();
                }
            }
        };
        this.invoke(runnable);
    }

    public final JFrame getApplicationFrame() {
        return this.applicationFrame;
    }

    public final void addWindow(Window win) {
        this.dependentWindows.add(win);
    }

    public final void removeWindow(Window win) {
        this.dependentWindows.remove(win);
    }

    public final void closeDependentWindows() {
        ArrayList<Window> aux = new ArrayList<Window>();
        aux.addAll(this.dependentWindows);
        for (Window window : aux) {
            window.setVisible(false);
            window.dispose();
        }
        this.dependentWindows.clear();
    }

    private void invoke(Runnable code) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                code.run();
            } else {
                SwingUtilities.invokeAndWait(code);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final class WindowCloseListener
    extends WindowAdapter {
        private WindowCloseListener() {
        }

        @Override
        public void windowClosing(WindowEvent arg) {
            AbstractCSDKWindowApplication.this.finishApplication();
        }
    }
}

