/*
 * Decompiled with CFR 0.152.
 */
package csdk.v1_0.runner.application;

import csdk.v1_0.api.application.ApplicationException;
import csdk.v1_0.api.application.IApplication;
import csdk.v1_0.api.application.IApplicationContext;
import csdk.v1_0.api.application.IMessage;
import csdk.v1_0.api.application.IMessageSender;
import csdk.v1_0.api.core.ICSDKEnvironment;
import csdk.v1_0.api.core.IContext;
import csdk.v1_0.api.filesystem.project.IProjectContext;
import csdk.v1_0.api.filesystem.project.IProjectObserver;
import csdk.v1_0.runner.ApplicationManager;
import csdk.v1_0.runner.ApplicationRegistry;
import csdk.v1_0.runner.IContextFactory;
import csdk.v1_0.runner.core.RunnerEnvironment;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import tecgraf.javautils.core.lng.LNG;

public class RunnerApplication
implements IApplication {
    private static final String ERROR_PREFIX = RunnerApplication.class.getSimpleName();
    private static int instanceCounter = 0;
    private final IApplication application;
    private final RunnerEnvironment runnerEnv;

    public RunnerApplication(ApplicationRegistry registry) throws ApplicationException {
        String id = registry.getApplicationId();
        String instanceId = RunnerApplication.generateInstanceId(id);
        this.runnerEnv = this.createCSDKEnvironment(instanceId, registry);
        Class<? extends IApplication> appClass = this.loadApplicationClass(registry);
        if (appClass == null) {
            throw new ApplicationException("No class found for " + id + "!");
        }
        try {
            Constructor<? extends IApplication> constructor = appClass.getConstructor(ICSDKEnvironment.class);
            this.application = constructor.newInstance(this.runnerEnv);
        }
        catch (InvocationTargetException e) {
            Throwable appException = e.getTargetException();
            String message = LNG.get((String)(ERROR_PREFIX + ".instatiation.exception"), (Object[])new Object[]{id, appClass.getName(), appException.getLocalizedMessage()});
            throw new ApplicationException(message, appException);
        }
        catch (NoSuchMethodException e) {
            String message = LNG.get((String)(ERROR_PREFIX + ".no.valid.constructor"), (Object[])new Object[]{id, appClass.getName()});
            throw new ApplicationException(message, (Throwable)e);
        }
        catch (InstantiationException e) {
            String message = LNG.get((String)(ERROR_PREFIX + ".no.instantiation"), (Object[])new Object[]{id, appClass.getName()});
            throw new ApplicationException(message, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            String message = LNG.get((String)(ERROR_PREFIX + ".application.manager.bad.implementation"), (Object[])new Object[]{id, appClass.getName()});
            throw new ApplicationException(message, (Throwable)e);
        }
    }

    private Class<? extends IApplication> loadApplicationClass(ApplicationRegistry reg) throws ApplicationException {
        try {
            ClassLoader classloader = reg.getClassloader();
            Class<?> loadedClass = Class.forName(reg.getClassName(), true, classloader);
            if (IApplication.class.isAssignableFrom(loadedClass)) {
                return loadedClass;
            }
            throw new IllegalArgumentException("Classe principal da aplica\u00e7\u00e3o n\u00e3o implementa a interface " + IApplication.class.getName());
        }
        catch (Exception e) {
            throw new ApplicationException("Erro ao carregar a classe principal da aplica\u00e7\u00e3o", (Throwable)e);
        }
    }

    private RunnerEnvironment createCSDKEnvironment(String instanceId, ApplicationRegistry registry) throws ApplicationException {
        ApplicationManager appManager = ApplicationManager.getInstance();
        IContextFactory contextFactory = appManager.getContextFactory();
        Map<Class<? extends IContext>, IContext> contexts = contextFactory.createCSDKContexts(instanceId, registry, appManager.getRunnerProperties());
        if (contexts == null || contexts.isEmpty() || !contexts.containsKey(IApplicationContext.class)) {
            throw new ApplicationException("Context factory must create the mandatory context " + IApplicationContext.class.getSimpleName());
        }
        if (registry.requiresProject()) {
            if (!contexts.containsKey(IProjectContext.class)) {
                throw new ApplicationException("Application cannot be run without a project context (" + IProjectContext.class.getSimpleName() + ")");
            }
            IProjectContext projectContext = (IProjectContext)contexts.get(IProjectContext.class);
            projectContext.addProjectObserver(new IProjectObserver(){

                public void onProjectOpen(String projectId) {
                }

                public void onProjectClose(String projectId) {
                    RunnerApplication.this.finishApplication();
                }
            });
        }
        return new RunnerEnvironment(contexts);
    }

    private static synchronized String generateInstanceId(String id) {
        return id + "_" + ++instanceCounter;
    }

    public boolean canEndApplication() {
        return this.application.canEndApplication();
    }

    public boolean finishApplication() {
        if (!this.canEndApplication()) {
            return false;
        }
        this.killApplication();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killApplication() {
        try {
            this.application.onApplicationEnd();
        }
        catch (ApplicationException e) {
            String errorMsg = LNG.get((String)(ERROR_PREFIX + ".finish.error"));
            System.err.println(errorMsg);
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        finally {
            this.runnerEnv.cleanupContexts();
        }
    }

    public void onMessageReceived(IMessage message, IMessageSender sender) {
        this.application.onMessageReceived(message, sender);
    }

    public void onApplicationEnd() throws ApplicationException {
        this.killApplication();
    }

    public void onApplicationStart() throws ApplicationException {
        this.application.onApplicationStart();
    }

    public String getInstanceId() {
        IApplicationContext context = this.runnerEnv.getContext(IApplicationContext.class);
        return context.getInstanceId();
    }

    public String getApplicationId() {
        IApplicationContext context = this.runnerEnv.getContext(IApplicationContext.class);
        return context.getApplicationId();
    }

    public IApplication getApplication() {
        return this.application;
    }
}

