/*
 * Decompiled with CFR 0.152.
 */
package csdk.v1_0.runner.filesystem;

import csdk.v1_0.runner.filesystem.FileType;
import java.util.ArrayList;

public class FileTypes {
    public static final String UNKNOWN = "UNKNOWN";
    public static final String DIRECTORY_TYPE = "DIRECTORY_TYPE";
    private static ArrayList<FileType> e2tList = new ArrayList();

    public static FileType createFileType(String typeName) {
        if (FileTypes.hasFileType(typeName)) {
            String err = "Type " + typeName + " already exists!";
            throw new IllegalArgumentException(err);
        }
        FileType typ = new FileType(typeName);
        e2tList.add(typ);
        return typ;
    }

    public static FileType getFileType(String fileTypeName) {
        if (fileTypeName == null) {
            return null;
        }
        String typeName = fileTypeName.trim();
        if (typeName.equals(UNKNOWN)) {
            return null;
        }
        for (FileType value : e2tList) {
            String name = value.getName();
            if (!name.equalsIgnoreCase(typeName)) continue;
            return value;
        }
        return null;
    }

    public static boolean hasFileType(String typeName) {
        return FileTypes.getFileType(typeName) != null;
    }

    public static FileType getFileTypeFromExtension(String extension) {
        if (extension == null) {
            throw new RuntimeException("Internal error: null extension not allowed");
        }
        for (FileType value : e2tList) {
            ArrayList<String> extensions = value.getExtensions();
            for (String ext : extensions) {
                if (!extension.trim().equalsIgnoreCase(ext.trim())) continue;
                return value;
            }
        }
        return null;
    }

    public static String[] getExtensionsFromFileType(String typeName) {
        if (typeName == null) {
            throw new RuntimeException("Internal error: null type name not allowed");
        }
        if (typeName.equals(UNKNOWN)) {
            return null;
        }
        for (FileType value : e2tList) {
            String name = value.getName();
            if (!name.trim().equalsIgnoreCase(typeName.trim())) continue;
            ArrayList<String> extensions = value.getExtensions();
            int sz = extensions.size();
            return extensions.toArray(new String[sz]);
        }
        return null;
    }
}

