/*
 * Decompiled with CFR 0.152.
 */
package csdk.v1_0.runner.filesystem.local;

import csdk.v1_0.api.filesystem.FileLocationType;
import csdk.v1_0.api.filesystem.FileSelectionType;
import csdk.v1_0.api.filesystem.IFile;
import csdk.v1_0.api.filesystem.local.ILocalFileSystemContext;
import csdk.v1_0.api.filesystem.local.LocalFileSystemException;
import csdk.v1_0.runner.core.AbstractContext;
import csdk.v1_0.runner.filesystem.FileType;
import csdk.v1_0.runner.filesystem.FileTypes;
import csdk.v1_0.runner.filesystem.RunnerFile;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.LNG;

public class LocalFileSystemContext
extends AbstractContext
implements ILocalFileSystemContext {
    public IFile getLocalFile(String[] path) throws LocalFileSystemException {
        return this.getFile(path);
    }

    public IFile createLocalFile(String[] path, String name, boolean isDir) throws LocalFileSystemException {
        File file = this.createFile(path, name, isDir);
        if (file == null) {
            return null;
        }
        return new RunnerFile(file);
    }

    public IFile browseLocalFileInOpenMode(String[] fileTypes, boolean allowAll, IFile currentDir, FileSelectionType fileSelectionType, Window frame) throws LocalFileSystemException {
        int mode = 0;
        List<IFile> selectedFiles = this.browse(mode, fileTypes, allowAll, null, currentDir, fileSelectionType, frame, false);
        if (selectedFiles == null || selectedFiles.isEmpty()) {
            return null;
        }
        return selectedFiles.iterator().next();
    }

    public IFile[] browseMultipleLocalFilesInOpenMode(String[] fileTypes, boolean allowAll, IFile currentDir, FileSelectionType fileSelectionType, Window frame) throws LocalFileSystemException {
        int mode = 0;
        List<IFile> selectedFiles = this.browse(mode, fileTypes, allowAll, null, currentDir, fileSelectionType, frame, true);
        if (selectedFiles == null || selectedFiles.isEmpty()) {
            return null;
        }
        return selectedFiles.toArray(new IFile[selectedFiles.size()]);
    }

    public IFile browseLocalFileInSaveMode(String[] fileTypes, boolean allowAll, String defaultName, IFile currentDir, Window frame) throws LocalFileSystemException {
        int mode = 1;
        List<IFile> selectedFiles = this.browse(mode, fileTypes, allowAll, defaultName, currentDir, FileSelectionType.FILES_ONLY, frame, false);
        if (selectedFiles == null || selectedFiles.isEmpty()) {
            return null;
        }
        return selectedFiles.iterator().next();
    }

    public boolean removeLocalFile(String[] path) {
        String filePath = FileUtils.joinPath((String[])path);
        File file = new File(filePath);
        return file.delete();
    }

    private List<IFile> browse(int mode, String[] fileTypes, boolean allowAll, String defaultName, IFile currentDir, FileSelectionType selectionType, Window frame, boolean isMultipleSelection) throws LocalFileSystemException {
        int returnVal;
        JFileChooser fc = new JFileChooser(){

            @Override
            public void approveSelection() {
                File f = this.getSelectedFile();
                if (f.exists() && !f.isDirectory() && this.getDialogType() == 1) {
                    String confirmMessage = LNG.get((String)(LocalFileSystemContext.class.getSimpleName() + ".overwrite.message"));
                    int result = JOptionPane.showConfirmDialog(this, confirmMessage, null, 1);
                    switch (result) {
                        case 0: {
                            super.approveSelection();
                            return;
                        }
                        case 1: {
                            return;
                        }
                        case -1: {
                            return;
                        }
                        case 2: {
                            this.cancelSelection();
                            return;
                        }
                    }
                }
                super.approveSelection();
            }
        };
        fc.setLocale(LNG.getLocale());
        fc.setDialogType(mode);
        int fileChooserType = selectionType == FileSelectionType.DIRECTORIES_ONLY ? 1 : 0;
        fc.setFileSelectionMode(fileChooserType);
        fc.setMultiSelectionEnabled(isMultipleSelection);
        if (currentDir != null) {
            if (currentDir.getFileLocationType() == FileLocationType.LOCAL) {
                File dir = new File(currentDir.getStringPath());
                fc.setCurrentDirectory(dir);
            } else {
                throw new LocalFileSystemException("Current directory " + currentDir.getStringPath() + "is not a local file");
            }
        }
        if (defaultName != null) {
            fc.setSelectedFile(new File(defaultName));
        }
        if (fileTypes != null && fileChooserType != 1) {
            for (String ft : fileTypes) {
                FileType tp = FileTypes.getFileType(ft);
                if (tp == null) continue;
                ArrayList<String> extensions = tp.getExtensions();
                FileNameExtensionFilter filter = new FileNameExtensionFilter(tp.getName(), extensions.toArray(new String[extensions.size()]));
                fc.addChoosableFileFilter(filter);
            }
            fc.setAcceptAllFileFilterUsed(allowAll);
        }
        if ((returnVal = fc.showDialog(frame, null)) == 0) {
            ArrayList<IFile> runnerFiles = new ArrayList<IFile>();
            if (isMultipleSelection) {
                File[] selectedFiles;
                for (File selectedFile : selectedFiles = fc.getSelectedFiles()) {
                    runnerFiles.add(new RunnerFile(selectedFile));
                }
            } else {
                File selectedFile = fc.getSelectedFile();
                runnerFiles.add(new RunnerFile(selectedFile));
            }
            return runnerFiles;
        }
        return null;
    }

    private IFile getFile(String[] path) {
        String filePath = FileUtils.joinPath((String[])path);
        File file = new File(filePath);
        if (file.exists()) {
            return new RunnerFile(file);
        }
        return null;
    }

    private File createFile(String[] path, String name, boolean isDir) throws LocalFileSystemException {
        File parent = path == null || path.length == 0 ? new File(".") : new File(FileUtils.joinPath((String[])path));
        File file = new File(parent, name);
        if (file.exists()) {
            return null;
        }
        try {
            if (isDir ? !file.mkdir() : !file.createNewFile()) {
                return null;
            }
        }
        catch (IOException e) {
            throw new LocalFileSystemException((Throwable)e);
        }
        return file;
    }
}

