/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.text.MessageFormat;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.print.PrintableText;
import tecgraf.javautils.gui.print.PrintableUI;

public class PrintableFooter
extends PrintableText {
    private String centerText;
    private String privateText;

    public PrintableFooter(String leftText, Font font) {
        this(leftText, font, true);
    }

    public PrintableFooter(String leftText, Font font, boolean changeFont) {
        this(leftText, null, font, changeFont);
    }

    public PrintableFooter(String leftText, String centerText, Font font) {
        this(leftText, centerText, font, true);
    }

    public PrintableFooter(String leftText, String centerText, Font font, boolean changeFont) {
        this(leftText, centerText, font, changeFont, null);
    }

    public PrintableFooter(String leftText, String centerText, Font font, boolean changeFont, String privateText) {
        super("\n" + MessageFormat.format(LNG.get((String)"tecgraf.javautils.gui.print.PrintableFooter.left.text"), leftText, System.currentTimeMillis()), font, changeFont);
        this.centerText = centerText;
        this.privateText = privateText;
    }

    @Override
    public boolean print(Graphics2D g2, PageFormat format, int pageIndex) {
        boolean fullPrinted = super.print(g2, format, pageIndex);
        if (!fullPrinted) {
            return false;
        }
        fullPrinted = this.printCenterText(g2, format, pageIndex);
        if (!fullPrinted) {
            return false;
        }
        return this.printPageNumber(g2, format, pageIndex);
    }

    private boolean printCenterText(Graphics2D g2, PageFormat format, int pageIndex) {
        if (this.centerText == null) {
            return true;
        }
        this.pt.setLocation(format.getImageableX(), format.getImageableY());
        this.textTool.getBBox(g2, this.getText(), this.pt, "nw", this.rect);
        this.pt.setLocation(this.rect.getMaxX(), format.getImageableY());
        String text = "\n      " + this.centerText;
        this.textTool.getBBox(g2, text, this.pt, "nw", this.rect);
        if (this.rect.getHeight() > format.getImageableHeight()) {
            return false;
        }
        this.textTool.draw(g2, text, this.pt, "nw");
        return true;
    }

    private boolean printPageNumber(Graphics2D g2, PageFormat format, int pageIndex) {
        this.pt.setLocation(format.getImageableX() + format.getImageableWidth(), format.getImageableY());
        this.textTool.getBBox(g2, "\n1", this.pt, "ne", this.rect);
        if (this.rect.getHeight() > format.getImageableHeight()) {
            return false;
        }
        String pageNumber = "\n" + Integer.toString(pageIndex + 1);
        this.textTool.draw(g2, pageNumber, this.pt, "ne");
        if (this.privateText != null) {
            Font originalFont = g2.getFont();
            Color originalColor = g2.getColor();
            this.pt.setLocation(this.pt.getX() - 10.0 * this.rect.getWidth(), this.pt.getY() + this.rect.getHeight() * 4.0 / 5.0);
            g2.setFont(PrintableUI.PRIVATE_PRINT_FONT);
            g2.setColor(PrintableUI.PRIVATE_COLOR_FONT);
            this.textTool.draw(g2, this.privateText, this.pt, "se");
            g2.setFont(originalFont);
            g2.setColor(originalColor);
        }
        return true;
    }
}

