/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.table;

import java.util.Map;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import tecgraf.javautils.gui.table.FooterCell;

public abstract class FooterModelWrapper
implements TableModel,
TableModelListener {
    private EventListenerList listenerList;
    private TableModel model;
    private String totalText;
    private Map<Integer, Number> footerValues;
    private int weight;

    public FooterModelWrapper(TableModel model, String totalText) {
        if (model == null) {
            throw new IllegalArgumentException("model==null");
        }
        this.weight = FooterModelWrapper.class.isInstance(model) ? ((FooterModelWrapper)FooterModelWrapper.class.cast(model)).getWeight() + 1 : 0;
        this.model = model;
        model.addTableModelListener(this);
        this.totalText = totalText;
        this.listenerList = new EventListenerList();
    }

    private int getWeight() {
        return this.weight;
    }

    protected abstract Map<Integer, Number> getFooterValues();

    public TableModel getModel() {
        return this.model;
    }

    @Override
    public int getRowCount() {
        int originalRows = this.model.getRowCount();
        return originalRows == 0 ? 0 : originalRows + 1;
    }

    @Override
    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    @Override
    public synchronized Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < this.model.getRowCount()) {
            return this.model.getValueAt(rowIndex, columnIndex);
        }
        if (columnIndex == 0) {
            return new FooterCell(this.totalText, this.weight);
        }
        if (this.footerValues == null) {
            this.footerValues = this.getFooterValues();
        }
        return new FooterCell(this.footerValues.get(columnIndex), this.weight);
    }

    @Override
    public synchronized void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (rowIndex < this.model.getRowCount()) {
            this.model.setValueAt(value, rowIndex, columnIndex);
        }
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.model.getColumnName(columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.model.getColumnClass(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.model.isCellEditable(rowIndex, columnIndex);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listenerList.add(TableModelListener.class, l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listenerList.remove(TableModelListener.class, l);
    }

    private void fireTableChanged(TableModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableModelListener.class) continue;
            ((TableModelListener)listeners[i + 1]).tableChanged(e);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.footerValues = this.getFooterValues();
        if (e.getType() == -1 && this.model.getRowCount() == 0) {
            this.fireTableChanged(new TableModelEvent(this, e.getFirstRow(), e.getLastRow() + 1, -1, -1));
        } else {
            this.fireTableChanged(e);
        }
    }
}

