/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagLayout;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import tecgraf.javautils.gui.GBC;

public class MultiLinePanelHeaderRenderer
implements TableCellRenderer,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Icon icon;
    protected Color backgroundColor = UIManager.getColor("TableHeader.background");
    protected Color foregroundColor;
    protected boolean multilineForce = false;
    protected Border headerBorder;
    protected Font font = UIManager.getFont("TableHeader.font");
    private boolean boldOn;
    private boolean italicOn;
    private boolean underlineOn;
    private boolean strikeOn;
    private int verticalGap = 8;
    private int lineSpace = 2;
    private int iconTextGap = 4;
    private int horizontalTextPosition = LEFT;
    protected static int LEFT = 2;
    protected static int RIGHT = 4;

    public MultiLinePanelHeaderRenderer() {
        this.foregroundColor = UIManager.getColor("TableHeader.foreground");
        this.backgroundColor = UIManager.getColor("TableHeader.background");
        this.headerBorder = UIManager.getBorder("TableHeader.cellBorder");
    }

    public MultiLinePanelHeaderRenderer(ImageIcon icon) {
        this();
        this.icon = icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String str = value == null ? "" : value.toString();
        BufferedReader br = new BufferedReader(new StringReader(str));
        ArrayList<String> v = new ArrayList<String>();
        int lines = 0;
        try {
            String line;
            while ((line = br.readLine()) != null) {
                v.add(line);
                ++lines;
            }
            if (this.multilineForce && lines < 2) {
                v.add(" ");
                ++lines;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Object[] values = v.toArray();
        int length = lines;
        JPanel labelPanel = this.makeTextPanel(table, values, length);
        labelPanel.setAlignmentY(RIGHT);
        JPanel headerPanel = new JPanel(new GridBagLayout());
        GBC gbcLabel = new GBC(0, 0);
        if (this.isRightHorizontalTextPosition()) {
            gbcLabel = new GBC(1, 0);
        }
        headerPanel.add((Component)labelPanel, gbcLabel);
        if (this.hasIconPanel()) {
            JPanel iconPanel = this.makeIconPanel(length);
            GBC gbcIcon = new GBC(1, 0).left(this.getIconTextGap());
            if (this.isRightHorizontalTextPosition()) {
                gbcIcon = new GBC(0, 0).right(this.getIconTextGap());
            }
            headerPanel.add((Component)iconPanel, gbcIcon);
        }
        if (this.backgroundColor != null) {
            headerPanel.setBackground(this.backgroundColor);
        }
        headerPanel.setBorder(this.headerBorder);
        headerPanel.setOpaque(true);
        return headerPanel;
    }

    protected boolean hasIconPanel() {
        return this.icon != null;
    }

    private JPanel makeTextPanel(JTable table, Object[] values, int length) {
        JTableHeader header;
        JPanel labelPanel = new JPanel(new GridBagLayout());
        labelPanel.setFont(table.getFont());
        FontMetrics metrics = labelPanel.getFontMetrics(labelPanel.getFont());
        if (table != null && (header = table.getTableHeader()) != null) {
            labelPanel.setForeground(header.getForeground());
            labelPanel.setBackground(header.getBackground());
        }
        int maxHeight = (metrics.getHeight() + this.lineSpace) * length + this.verticalGap;
        for (int i = 0; i < length; ++i) {
            JLabel l = new JLabel();
            this.setValue(l, values[i]);
            labelPanel.add((Component)l, new GBC(0, i).gridheight(1).gridwidth(1));
        }
        Dimension d = labelPanel.getPreferredSize();
        d.height = Math.max(d.height, maxHeight);
        labelPanel.setPreferredSize(d);
        labelPanel.setOpaque(false);
        return labelPanel;
    }

    protected JPanel makeIconPanel(int length) {
        JLabel label = this.makeIconLabel(this.icon);
        JPanel iconPanel = new JPanel(new GridBagLayout());
        iconPanel.setOpaque(false);
        iconPanel.add((Component)label, new GBC(0, 0).none());
        return iconPanel;
    }

    protected JLabel makeIconLabel(Icon icon) {
        JLabel label = new JLabel();
        label.setOpaque(false);
        label.setForeground(this.getForegroundColor());
        label.setBackground(this.getBackgroundColor());
        label.setFont(this.font);
        label.setIcon(icon);
        return label;
    }

    private boolean isRightHorizontalTextPosition() {
        return this.horizontalTextPosition == RIGHT;
    }

    protected void setValue(JLabel l, Object value) {
        StringBuilder labelText = new StringBuilder();
        if (this.boldOn || this.italicOn || this.underlineOn || this.strikeOn) {
            labelText.append("<html>");
        }
        if (this.boldOn) {
            labelText.append("<b>");
        }
        if (this.italicOn) {
            labelText.append("<i>");
        }
        if (this.underlineOn) {
            labelText.append("<u>");
        }
        if (this.strikeOn) {
            labelText.append("<strike>");
        }
        if (value != null) {
            labelText.append(value.toString());
        }
        if (this.strikeOn) {
            labelText.append("</strike>");
        }
        if (this.underlineOn) {
            labelText.append("</u>");
        }
        if (this.italicOn) {
            labelText.append("</i>");
        }
        if (this.boldOn) {
            labelText.append("</b>");
        }
        if (this.boldOn || this.italicOn || this.underlineOn || this.strikeOn) {
            labelText.append("</html>");
        }
        l.setText(labelText.toString());
        l.setForeground(this.getForegroundColor());
        l.setBackground(this.getBackgroundColor());
        l.setHorizontalAlignment(RIGHT);
        l.setHorizontalTextPosition(4);
        l.setOpaque(false);
        l.setFont(this.font);
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setForegroundColor(Color color) {
        this.foregroundColor = color;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setMultilineForce(boolean multiline) {
        this.multilineForce = multiline;
    }

    public void setTextStyleEnabled(TextStyle style, boolean enable) {
        switch (style) {
            case BOLD: {
                this.boldOn = enable;
                break;
            }
            case ITALIC: {
                this.italicOn = enable;
                break;
            }
            case UNDERLINE: {
                this.underlineOn = enable;
                break;
            }
            case STRIKETHROUGH: {
                this.strikeOn = enable;
            }
        }
    }

    public void setVerticalGap(int vertGap) {
        this.verticalGap = vertGap;
    }

    public void setLineSpace(int space) {
        this.lineSpace = space;
    }

    public int getIconTextGap() {
        return this.iconTextGap;
    }

    public void setIconTextGap(int iconTextGap) {
        this.iconTextGap = iconTextGap;
    }

    public int getHorizontalTextPosition() {
        return this.horizontalTextPosition;
    }

    public void setHorizontalTextPosition(int horizontalTextPosition) {
        if (horizontalTextPosition != LEFT && horizontalTextPosition != RIGHT) {
            throw new IllegalArgumentException("Os parametros aceitos s\u00e3o: LEFT e RIGHT");
        }
        this.horizontalTextPosition = horizontalTextPosition;
    }

    public static enum TextStyle {
        BOLD,
        ITALIC,
        UNDERLINE,
        STRIKETHROUGH;

    }
}

