/*
 * Decompiled with CFR 0.152.
 */
package screensframework;

import java.net.URL;
import java.util.HashMap;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import screensframework.ControlledScreen;

public class ScreensController
extends StackPane {
    private HashMap<String, Node> screens = new HashMap();

    public void addScreen(String name, Node screen) {
        this.screens.put(name, screen);
    }

    public Node getScreen(String name) {
        return this.screens.get(name);
    }

    public boolean loadScreen(String name, String resource) {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        URL res = clazz.getResource(resource);
        try {
            FXMLLoader myLoader = new FXMLLoader(res);
            myLoader.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            Parent loadScreen = (Parent)myLoader.load();
            ControlledScreen myScreenControler = (ControlledScreen)myLoader.getController();
            myScreenControler.setScreenParent(this);
            this.addScreen(name, (Node)loadScreen);
            return true;
        }
        catch (Exception e) {
            System.out.println("loadScreen exception [" + e.getMessage() + "] URL: " + res);
            e.printStackTrace();
            return false;
        }
    }

    public boolean setScreen(final String name) {
        if (this.screens.get(name) != null) {
            final DoubleProperty opacity = this.opacityProperty();
            if (!this.getChildren().isEmpty()) {
                Timeline fade = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)opacity, (Object)1.0)}), new KeyFrame(new Duration(1000.0), (EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent t) {
                        ScreensController.this.getChildren().remove(0);
                        ScreensController.this.getChildren().add(0, ScreensController.this.screens.get(name));
                        Timeline fadeIn = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)opacity, (Object)0.0)}), new KeyFrame(new Duration(800.0), new KeyValue[]{new KeyValue((WritableValue)opacity, (Object)1.0)})});
                        fadeIn.play();
                    }
                }, new KeyValue[]{new KeyValue((WritableValue)opacity, (Object)0.0)})});
                fade.play();
            } else {
                this.setOpacity(0.0);
                this.getChildren().add((Object)this.screens.get(name));
                Timeline fadeIn = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)opacity, (Object)0.0)}), new KeyFrame(new Duration(2500.0), new KeyValue[]{new KeyValue((WritableValue)opacity, (Object)1.0)})});
                fadeIn.play();
            }
            return true;
        }
        System.out.println("screen hasn't been loaded!!! \n");
        return false;
    }

    public boolean unloadScreen(String name) {
        if (this.screens.remove(name) == null) {
            System.out.println("Screen didn't exist");
            return false;
        }
        return true;
    }
}

