package snakegame;

import java.util.Timer;
import java.util.TimerTask;

import javax.swing.JFrame;
import javax.swing.SwingUtilities;

import snakegame.exception.GameOverException;
import snakegame.exception.VictoryException;
import snakegame.map.SnakeTableModel;
import snakegame.session.Mode;
import snakegame.session.Session;
import tecgraf.javautils.gui.StandardDialogs;

/**
 * Rotina responsvel pelo andamento do jogo.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class MoveTask extends TimerTask {

  /** Sesso. */
  private Session session;

  /** Temporizador. */
  private Timer timer;

  /** Modelo da tabela. */
  private SnakeTableModel model;

  /** Janela-pai. */
  private JFrame frame;

  /**
   * Construtor.
   * 
   * @param session sesso.
   * @param timer temporizador.
   * @param model modelo da tabela.
   * @param frame janela-pai.
   */
  public MoveTask(Session session, Timer timer, SnakeTableModel model,
    JFrame frame) {
    if (session == null) {
      throw new IllegalArgumentException("session no pode ser nulo.");
    }
    if (timer == null) {
      throw new IllegalArgumentException("timer no pode ser nulo.");
    }
    if (model == null) {
      throw new IllegalArgumentException("model no pode ser nulo.");
    }
    if (frame == null) {
      throw new IllegalArgumentException("frame no pode ser nulo.");
    }
    this.session = session;
    this.timer = timer;
    this.model = model;
    this.frame = frame;
  }

  /** {@inheritDoc} */
  @Override
  public void run() {
    try {
      model.move();
      SwingUtilities.invokeLater(new Runnable() {
        @Override
        public void run() {
          model.fireTableDataChanged();
        }
      });

    }
    catch (GameOverException e) {
      timer.cancel();
      session.setMode(Mode.OFF);
      StandardDialogs.showErrorDialog(frame, frame.getTitle(), e.getMessage());
    }
    catch (VictoryException e) {
      timer.cancel();
      session.setMode(Mode.OFF);
      StandardDialogs.showInfoDialog(frame, frame.getTitle(), e.getMessage());
    }
  }
}
