package snakegame.algorithm.util;

import java.awt.Point;
import java.util.LinkedList;
import java.util.List;

import snakegame.map.Direction;

/**
 * Utilitrio.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class Util {

  /**
   * Retorna o ponto a frente da cobra.
   * 
   * @param snake cobra.
   * @param direction direo.
   * @param rows nmero total das linhas.
   * @param columns nmero total das colunas.
   * @return ponto a frente da cobra.
   */
  public static Point lookahead(List<Point> snake, Direction direction,
    int rows, int columns) {
    int x = snake.get(0).x;
    int y = snake.get(0).y;
    switch (direction) {
      case UP:
        x--;
        break;
      case DOWN:
        x++;
        break;
      case LEFT:
        y--;
        break;
      case RIGHT:
        y++;
        break;
    }
    if (x < 0 || x == rows || y < 0 || y == columns) {
      return null;
    }
    Point point = new Point(x, y);
    if (snake.contains(point)) {
      return null;
    }
    return point;
  }

  /**
   * Retorna a lista com as direes que a comida est em relao a cabea da
   * cobra.
   * 
   * @param head cabea.
   * @param food comida.
   * @return lista com as direes.
   */
  public static List<Direction> whereIsTheFood(Point head, Point food) {
    List<Direction> result = new LinkedList<Direction>();

    if (food.x < head.x) {
      result.add(Direction.UP);
    }
    if (food.x > head.x) {
      result.add(Direction.DOWN);
    }
    if (food.y < head.y) {
      result.add(Direction.LEFT);
    }
    if (food.y > head.y) {
      result.add(Direction.RIGHT);
    }
    return result;
  }

  /**
   * Retorna true se as dadas direes so opostas, false caso contrrio.
   * 
   * @param a direo.
   * @param b direo.
   * @return flag que define se as direes so opostas.
   */
  public static boolean isOpposite(Direction a, Direction b) {
    switch (a) {
      case UP:
        return b == Direction.DOWN;
      case DOWN:
        return b == Direction.UP;
      case LEFT:
        return b == Direction.RIGHT;
      case RIGHT:
        return b == Direction.LEFT;
      default:
        return false;
    }
  }
}
