/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.FileChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import tecgraf.ftc.common.exception.FailureException;
import tecgraf.ftc.common.exception.InvalidArraySize;
import tecgraf.ftc.common.exception.PermissionException;
import tecgraf.ftc.common.logic.ErrorCode;
import tecgraf.ftc.server.AccessKey;
import tecgraf.ftc.server.FileChannelAccessInfo;
import tecgraf.ftc.server.FileChannelRequestInfo;
import tecgraf.ftc.server.FileServerConfig;
import tecgraf.ftc.server.FileServerOwner;
import tecgraf.ftc.server.Session;
import tecgraf.ftc.server.states.CloseState;
import tecgraf.ftc.server.states.State;

public final class FileServer {
    private FileServerOwner fileServerOwner;
    private volatile boolean wasStopped;
    private Selector selector;
    private Map<AccessKey, FileChannelRequestInfo> channels;
    private FileServerConfig config = null;
    private ServerSocketChannel serverChannel = null;
    SelectionKey serverKey = null;
    private long lastTimeoutCheck = 0L;
    private static final Logger logger;
    public static final boolean PLATAFORM_HAS_TRANSFERTO_BUG;

    public FileServer(FileServerOwner fileServerOwner) throws IOException {
        this.fileServerOwner = fileServerOwner;
        this.config = fileServerOwner.getConfig();
        this.serverChannel = ServerSocketChannel.open();
        this.serverChannel.configureBlocking(false);
        ServerSocket serverSocket = this.serverChannel.socket();
        serverSocket.bind(new InetSocketAddress(this.config.getHostName(), this.config.getPort()));
        this.selector = Selector.open();
        this.serverKey = this.serverChannel.register(this.selector, 16);
        this.channels = new HashMap<AccessKey, FileChannelRequestInfo>();
    }

    public void dispatch() {
        while (!this.wasStopped) {
            block10: {
                try {
                    int selectedKeyCount = this.selector.select(this.config.getSelectTimeout());
                    this.checkTimedOutConnections();
                    if (selectedKeyCount == 0) {
                    }
                    break block10;
                }
                catch (IOException e) {
                    this.exceptionRaised(e);
                }
                continue;
            }
            Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
            while (selectedKeys.hasNext()) {
                SelectionKey key = selectedKeys.next();
                selectedKeys.remove();
                if (this.serverKey.equals(key)) {
                    if (key.isValid()) {
                        if (!key.isAcceptable()) continue;
                        this.accept(key);
                        continue;
                    }
                    logger.finer("Erro desconhecido no socket servidor.");
                    this.stop();
                    continue;
                }
                Session session = (Session)key.attachment();
                if (key.isValid()) {
                    this.read(key);
                    if (key.isValid() && key.isWritable()) {
                        this.write(key);
                    }
                    if (!key.isValid() || !session.isValid()) continue;
                    int ops = session.isWriting() ? 5 : 1;
                    key.interestOps(ops);
                    continue;
                }
                if (session != null && logger.isLoggable(Level.FINER)) {
                    logger.finer(String.format("A conex\u00e3o com o cliente %s foi interrompida. Fechando o canal.", session.getClientAddress().toString()));
                }
                this.stopConnection(key, session);
            }
        }
        this.shutdownConnections();
    }

    private void checkTimedOutConnections() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastTimeoutCheck < this.config.getSelectTimeout()) {
            return;
        }
        this.lastTimeoutCheck = currentTime;
        Set<SelectionKey> keys = this.selector.keys();
        for (SelectionKey key : keys) {
            long test;
            Session session = (Session)key.attachment();
            if (session == null || (test = currentTime - session.getLastActivity()) <= this.config.getClientTimeout()) continue;
            logger.finer("Conexao fechada por inatividade.");
            this.stopConnection(key, session);
        }
    }

    private void shutdownConnections() {
        logger.finer("Fechando todas as conexoes.");
        for (SelectionKey key : this.selector.keys()) {
            Session session = (Session)key.attachment();
            this.stopConnection(key, session);
        }
        this.serverChannel = null;
    }

    public void stop() {
        logger.finer("O servidor FTC foi interrompido.");
        this.wasStopped = true;
    }

    public FileChannelAccessInfo createFileChannelInfo(Object requester, byte[] fileId) throws InvalidArraySize {
        return this.createFileChannelInfo(requester, fileId, null);
    }

    public FileChannelAccessInfo createFileChannelInfo(Object requester, byte[] fileId, byte[] accessKey) throws InvalidArraySize {
        return this.createFileChannelInfo(requester, fileId, accessKey, true);
    }

    public FileChannelAccessInfo createFileChannelInfo(Object requester, byte[] fileId, byte[] accessKey, boolean useTransferTo) throws InvalidArraySize {
        if (fileId == null) {
            throw new InvalidParameterException("fileId n\u00e3o pode ser nulo.");
        }
        if (fileId.length > 255) {
            throw new InvalidArraySize("Tamanho do fileId maior que o suportado.");
        }
        AccessKey key = accessKey != null ? new AccessKey(accessKey) : new AccessKey();
        FileChannelRequestInfo fileChannelIinfo = new FileChannelRequestInfo(requester, fileId);
        String host = this.config.getHostName();
        int port = this.serverChannel.socket().getLocalPort();
        logger.finer("Criando novo FileChannelInfo: ");
        logger.finer("\tfileId: " + DatatypeConverter.printHexBinary((byte[])fileId));
        logger.finer("\tuseTransferTo: " + useTransferTo);
        logger.finer("\thostname: " + host);
        logger.finer("\tport: " + port);
        fileChannelIinfo.useTransferTo(useTransferTo);
        this.channels.put(key, fileChannelIinfo);
        return new FileChannelAccessInfo(host, port, key.getBytes(), fileId);
    }

    public FileChannelRequestInfo getFileChannelInfo(AccessKey accessKey) {
        if (this.config.isTestMode()) {
            return this.channels.get(accessKey);
        }
        return this.channels.remove(accessKey);
    }

    public FileChannel createFileChannel(Object requester, byte[] fileId, boolean readOnly) throws PermissionException, FailureException {
        return this.fileServerOwner.createFileChannel(requester, fileId, readOnly);
    }

    public boolean isLocked(Object requester, byte[] fileId) {
        return this.fileServerOwner.isLocked(requester, fileId);
    }

    void fileChannelClosed(Object requester, byte[] fileId) {
        this.fileServerOwner.fileChannelClosed(requester, fileId);
    }

    public void exceptionRaised(Exception e, byte[] fileId) {
        this.fileServerOwner.exceptionRaised(e, fileId);
    }

    public void exceptionRaised(Exception e) {
        this.fileServerOwner.exceptionRaised(e);
    }

    private void accept(SelectionKey key) {
        ServerSocketChannel serverChannel = (ServerSocketChannel)key.channel();
        SocketChannel socketChannel = null;
        try {
            while ((socketChannel = serverChannel.accept()) != null) {
                socketChannel.configureBlocking(false);
                Session session = new Session(socketChannel, this);
                session.markLastActivity();
                socketChannel.register(this.selector, 1, session);
                int clients = this.selector.keys().size() - 1;
                if (clients > this.config.getMaxClients()) {
                    logger.info("N\u00famero m\u00e1ximo de clientes atingido.");
                    this.printKeysDebugInfo();
                    session.setCurrentState(new CloseState(ErrorCode.MAX_CLIENTS_REACHED));
                    break;
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Cliente conectado:" + socketChannel.socket().getRemoteSocketAddress());
                    logger.fine("Numero de clientes:" + clients);
                }
                if (this.config.acceptMaxPossible()) continue;
                break;
            }
            return;
        }
        catch (IOException e) {
            this.exceptionRaised(e);
        }
        catch (OutOfMemoryError e) {
            logger.warning("N\u00e3o h\u00e1 recursos suficientes. A Conex\u00e3o sera fechada.");
        }
        try {
            if (socketChannel != null) {
                socketChannel.close();
            }
        }
        catch (IOException ioe) {
            this.exceptionRaised(ioe);
        }
    }

    private void printKeysDebugInfo() {
        Set<SelectionKey> keys = this.selector.keys();
        logger.info("Chaves registradas: " + keys.size());
        logger.info("Chaves selecionadas: " + this.selector.selectedKeys().size());
        int invalidCount = 0;
        for (SelectionKey k : keys) {
            if (k.isValid()) continue;
            ++invalidCount;
            Session s = (Session)k.attachment();
            String sessionId = new String(s.getFileChannelInfo().getFileId());
            logger.info("Chave invalida -- sessao " + sessionId);
        }
        logger.info("Chaves invalidas: " + invalidCount);
    }

    private void read(SelectionKey key) {
        Session session = (Session)key.attachment();
        try {
            State currentState = session.getCurrentState();
            if (currentState == null || !currentState.read(session)) {
                this.stopConnection(key, session);
            }
        }
        catch (Exception e) {
            if (session != null && session.getFileChannelInfo() != null) {
                this.exceptionRaised(e, session.getFileChannelInfo().getFileId());
            } else {
                this.exceptionRaised(e);
            }
            this.stopConnection(key, session);
        }
    }

    private void write(SelectionKey key) {
        Session session = (Session)key.attachment();
        try {
            State currentState = session.getCurrentState();
            if (currentState == null || !currentState.write(session)) {
                this.stopConnection(key, session);
            }
        }
        catch (Exception e) {
            if (session != null) {
                this.exceptionRaised(e, session.getFileChannelInfo().getFileId());
            } else {
                this.exceptionRaised(e);
            }
            this.stopConnection(key, session);
        }
    }

    private void stopConnection(SelectionKey key, Session session) {
        if (session != null) {
            session.close();
        } else {
            try {
                key.channel().close();
            }
            catch (IOException e) {
                this.exceptionRaised(e);
            }
        }
        key.attach(null);
        key.cancel();
    }

    public FileServerConfig getConfig() {
        return this.config;
    }

    public void setConfig(FileServerConfig config) {
        this.config = config;
    }

    static {
        String[] patchNumbers;
        int update;
        logger = Logger.getLogger("tecgraf.ftc");
        String javaVersion = System.getProperty("java.version");
        String[] versionNumbers = javaVersion.split("[.]");
        int minor = Integer.parseInt(versionNumbers[1]);
        PLATAFORM_HAS_TRANSFERTO_BUG = System.getProperty("os.name").contains("Linux") && System.getProperty("sun.arch.data.model").contains("32") && minor <= 6 ? (minor == 6 ? (update = Integer.parseInt((patchNumbers = versionNumbers[2].split("[_]"))[1])) < 18 : true) : false;
    }
}

