/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc.server.states;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc.common.exception.InvalidArraySize;
import tecgraf.ftc.common.logic.ErrorCode;
import tecgraf.ftc.common.logic.PrimitiveTypeSize;
import tecgraf.ftc.server.AccessKey;
import tecgraf.ftc.server.FileChannelRequestInfo;
import tecgraf.ftc.server.FileServer;
import tecgraf.ftc.server.Session;
import tecgraf.ftc.server.states.GetOperationState;
import tecgraf.ftc.server.states.State;

public final class ValidateKeyState
implements State {
    private InternalState currentState = InternalState.INITIAL;
    private int keySize;
    private byte[] key;
    private ErrorCode errorCode;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    private boolean writing = false;

    public ValidateKeyState() {
        logger.finer("Estado de valida\u00e7\u00e3o de chave.");
    }

    @Override
    public boolean read(Session session) throws IOException {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case INITIAL: {
                buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                int bytesRead = channel.read(buffer);
                if (bytesRead < 0) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(String.format("A conex\u00e3o com o cliente %s foi interrompida.", session.getClientAddress().toString()));
                    }
                    return false;
                }
                if (bytesRead > 0) {
                    session.markLastActivity();
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.keySize = buffer.get() & 0xFF;
                buffer.clear();
                this.currentState = InternalState.KEY_SIZE_RECEIVED;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Tamanho da chave lido " + this.keySize);
                }
            }
            case KEY_SIZE_RECEIVED: {
                buffer.limit(this.keySize);
                int bytesRead = channel.read(buffer);
                if (bytesRead < 0) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(String.format("A conex\u00e3o com o cliente %s foi interrompida.", session.getClientAddress().toString()));
                    }
                    return false;
                }
                if (bytesRead > 0) {
                    session.markLastActivity();
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.key = new byte[this.keySize];
                buffer.get(this.key);
                buffer.clear();
                this.currentState = InternalState.KEY_RECEIVED;
                this.writing = true;
                try {
                    AccessKey accessKey = new AccessKey(this.key);
                    FileServer fileServer = session.getFileServer();
                    FileChannelRequestInfo fileChannelInfo = fileServer.getFileChannelInfo(accessKey);
                    if (fileChannelInfo == null) {
                        this.errorCode = ErrorCode.INVALID_KEY;
                    } else {
                        this.errorCode = ErrorCode.OK;
                        session.setFileChannelInfo(fileChannelInfo);
                    }
                }
                catch (InvalidArraySize e) {
                    session.getFileServer().exceptionRaised(e);
                    this.errorCode = ErrorCode.INVALID_KEY;
                }
                buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                buffer.put(this.errorCode.getCode());
                buffer.flip();
            }
        }
        return true;
    }

    @Override
    public boolean write(Session session) throws IOException {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case KEY_RECEIVED: {
                int bytesWritten = channel.write(buffer);
                if (bytesWritten < 0) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(String.format("A conex\u00e3o com o cliente %s foi interrompida.", session.getClientAddress().toString()));
                    }
                    return false;
                }
                if (bytesWritten > 0) {
                    session.markLastActivity();
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.clear();
                this.currentState = InternalState.ERROR_CODE_SENT;
                this.writing = false;
                if (this.errorCode.equals((Object)ErrorCode.OK)) {
                    session.setCurrentState(new GetOperationState());
                } else {
                    session.setCurrentState(null);
                }
                if (!logger.isLoggable(Level.FINER)) break;
                logger.finer("C\u00f3digo " + (Object)((Object)this.errorCode) + " enviado.");
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    private static enum InternalState {
        INITIAL,
        KEY_SIZE_RECEIVED,
        KEY_RECEIVED,
        ERROR_CODE_SENT;

    }
}

