/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import tecgraf.ftc.common.logic.PrimitiveTypeSize;

public final class ByteBufferUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long readLong(ByteBuffer buffer, ReadableByteChannel channel) throws IOException {
        buffer.limit(PrimitiveTypeSize.LONG.getSize());
        try {
            do {
                if (channel.read(buffer) >= 0) continue;
                throw new IOException("End-of-Stream ou canal fechado!");
            } while (buffer.hasRemaining());
            buffer.flip();
            long l = buffer.getLong();
            return l;
        }
        finally {
            buffer.clear();
        }
    }

    public static byte readByte(ByteBuffer buffer, ReadableByteChannel channel) throws IOException {
        buffer.limit(PrimitiveTypeSize.BYTE.getSize());
        try {
            do {
                if (channel.read(buffer) >= 0) continue;
                throw new IOException("End-of-Stream ou canal fechado!");
            } while (buffer.hasRemaining());
            buffer.flip();
            byte by = buffer.get();
            return by;
        }
        finally {
            buffer.clear();
        }
    }

    public static void writeByte(ByteBuffer buffer, WritableByteChannel channel, byte value) throws IOException {
        ByteBufferUtils.writeByte(buffer, channel, 0, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeByte(ByteBuffer buffer, WritableByteChannel channel, int extraBytes, byte value) throws IOException {
        buffer.put(value);
        buffer.flip();
        try {
            int result;
            int bytesWritten = 0;
            do {
                if ((result = channel.write(buffer)) >= 0) continue;
                throw new IOException("End-of-Stream ou canal fechado!");
            } while ((bytesWritten += result) < PrimitiveTypeSize.BYTE.getSize() + extraBytes);
        }
        finally {
            buffer.clear();
        }
    }

    public static void writeLong(ByteBuffer buffer, WritableByteChannel channel, long value) throws IOException {
        ByteBufferUtils.writeLong(buffer, channel, 0, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLong(ByteBuffer buffer, WritableByteChannel channel, int extraBytes, long value) throws IOException {
        buffer.putLong(value);
        buffer.flip();
        try {
            int result;
            int bytesWritten = 0;
            do {
                if ((result = channel.write(buffer)) >= 0) continue;
                throw new IOException("End-of-Stream ou canal fechado!");
            } while ((bytesWritten += result) < PrimitiveTypeSize.LONG.getSize() + extraBytes);
        }
        finally {
            buffer.clear();
        }
    }

    public static void writeBytes(ByteBuffer buffer, WritableByteChannel channel, byte[] value) throws IOException {
        ByteBufferUtils.writeBytes(buffer, channel, 0, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBytes(ByteBuffer buffer, WritableByteChannel channel, int extraBytes, byte[] value) throws IOException {
        buffer.put((byte)value.length);
        buffer.put(value);
        buffer.flip();
        int bytesWritten = 0;
        try {
            while ((bytesWritten += channel.write(buffer)) < value.length + extraBytes) {
            }
        }
        finally {
            buffer.clear();
        }
    }
}

