/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.server.states.v1_2;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_4.common.logic.Operation;
import tecgraf.ftc_1_4.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_4.server.Session;
import tecgraf.ftc_1_4.server.states.State;
import tecgraf.ftc_1_4.server.states.v1_2.CloseState;
import tecgraf.ftc_1_4.server.states.v1_2.GetPositionState;
import tecgraf.ftc_1_4.server.states.v1_2.GetSizeState;
import tecgraf.ftc_1_4.server.states.v1_2.KeepAliveState;
import tecgraf.ftc_1_4.server.states.v1_2.OpenReadOnlyState;
import tecgraf.ftc_1_4.server.states.v1_2.OpenReadWriteState;
import tecgraf.ftc_1_4.server.states.v1_2.ReadState;
import tecgraf.ftc_1_4.server.states.v1_2.SetPositionState;
import tecgraf.ftc_1_4.server.states.v1_2.SetSizeState;
import tecgraf.ftc_1_4.server.states.v1_2.WriteState;

public final class GetOperationState
implements State {
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");

    @Override
    public boolean read(Session session) throws IOException {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        SocketAddress clientAddress = channel.socket().getRemoteSocketAddress();
        buffer.limit(PrimitiveTypeSize.BYTE.getSize());
        if (channel.read(buffer) < 0) {
            return false;
        }
        session.markLastActivity();
        if (buffer.hasRemaining()) {
            return true;
        }
        buffer.flip();
        byte operationCode = buffer.get();
        buffer.clear();
        Operation operation = Operation.valueOf(operationCode);
        if (operation == null) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe(String.format("Invalid operation with code %d requested by %s", operationCode, clientAddress));
            }
            return false;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(String.format("Operation %s requested by %s", new Object[]{operation, clientAddress}));
        }
        session.setCurrentState(this.getState(operation));
        return true;
    }

    private State getState(Operation operation) {
        switch (operation) {
            case OPEN_READ_ONLY: {
                return new OpenReadOnlyState();
            }
            case OPEN_READ_WRITE: {
                return new OpenReadWriteState();
            }
            case CLOSE: {
                return new CloseState();
            }
            case SET_SIZE: {
                return new SetSizeState();
            }
            case GET_POSITION: {
                return new GetPositionState();
            }
            case SET_POSITION: {
                return new SetPositionState();
            }
            case GET_SIZE: {
                return new GetSizeState();
            }
            case READ: {
                return new ReadState();
            }
            case WRITE: {
                return new WriteState();
            }
            case KEEP_ALIVE: {
                return new KeepAliveState();
            }
        }
        return null;
    }

    @Override
    public boolean write(Session session) {
        return true;
    }

    @Override
    public boolean isWriting() {
        return false;
    }
}

