/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.server.states.v1_4;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_4.common.exception.InvalidArraySize;
import tecgraf.ftc_1_4.common.logic.ErrorCode;
import tecgraf.ftc_1_4.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_4.common.logic.ResultMessage;
import tecgraf.ftc_1_4.server.AccessKey;
import tecgraf.ftc_1_4.server.FileChannelRequestInfo;
import tecgraf.ftc_1_4.server.Session;
import tecgraf.ftc_1_4.server.states.State;
import tecgraf.ftc_1_4.server.states.StateUtil;
import tecgraf.ftc_1_4.server.states.v1_4.GetOperationState;

public final class ValidateKeyState
implements State {
    private InternalState currentState = InternalState.INITIAL;
    private int keySize;
    private byte[] key;
    private ResultMessage result = new ResultMessage();
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    private boolean writing = false;

    @Override
    public boolean read(Session session) throws IOException {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        SocketAddress clientAddress = channel.socket().getRemoteSocketAddress();
        switch (this.currentState) {
            case INITIAL: {
                buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                if (channel.read(buffer) < 0) {
                    return false;
                }
                session.markLastActivity();
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.keySize = buffer.get() & 0xFF;
                buffer.clear();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(String.format("Access key received from connection %s is %d bytes length", clientAddress, this.keySize));
                }
                this.currentState = InternalState.KEY_SIZE_RECEIVED;
            }
            case KEY_SIZE_RECEIVED: {
                buffer.limit(this.keySize);
                if (channel.read(buffer) < 0) {
                    return false;
                }
                session.markLastActivity();
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.key = new byte[this.keySize];
                buffer.get(this.key);
                buffer.clear();
                this.writing = true;
                try {
                    AccessKey accessKey = new AccessKey(this.key);
                    long timestamp = System.currentTimeMillis();
                    FileChannelRequestInfo fileChannelInfo = session.getFileServer().getFileChannelInfo(accessKey);
                    if (fileChannelInfo == null) {
                        this.result.code = ErrorCode.INVALID_KEY;
                        if (logger.isLoggable(Level.WARNING)) {
                            logger.warning(String.format("No pending request found at %d timestamp (connection %s) for access key %s", timestamp, clientAddress, accessKey));
                        }
                    } else {
                        this.result.success = true;
                        session.setFileChannelInfo(fileChannelInfo);
                        if (logger.isLoggable(Level.INFO)) {
                            logger.info(String.format("Channel request retrieved at %d timestamp (connection %s) for access key %s", timestamp, clientAddress, accessKey));
                        }
                    }
                }
                catch (InvalidArraySize e) {
                    this.result.code = ErrorCode.INVALID_KEY;
                    this.result.message = e.getMessage();
                }
                this.currentState = InternalState.KEY_RECEIVED;
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean write(Session session) throws IOException {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        SocketAddress clientAddress = channel.socket().getRemoteSocketAddress();
        switch (this.currentState) {
            case KEY_RECEIVED: {
                StateUtil.writeResultMessage(buffer, this.result);
                buffer.flip();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(String.format("Validate key result (%s) written into buffer to connection %s", this.result, clientAddress));
                }
                this.currentState = InternalState.RESULT_MESSAGE_WRITTEN;
            }
            case RESULT_MESSAGE_WRITTEN: {
                if (channel.write(buffer) > 0) {
                    session.markLastActivity();
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                this.writing = false;
                buffer.clear();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(String.format("Validate key result (%s) sent successfully to %s", this.result, clientAddress));
                }
                this.currentState = InternalState.RESULT_MESSAGE_SENT;
                session.setCurrentState(this.result.success != false ? new GetOperationState() : null);
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    private static enum InternalState {
        INITIAL,
        KEY_SIZE_RECEIVED,
        KEY_RECEIVED,
        RESULT_MESSAGE_WRITTEN,
        RESULT_MESSAGE_SENT;

    }
}

