/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.api.application.v1.impl;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import ibase.common.ServiceAdapter;
import ibase.common.ServiceUtil;
import ibase.rest.api.application.v1.ApplicationsApiService;
import ibase.rest.api.application.v1.NotFoundException;
import ibase.rest.api.application.v1.adapter.ApplicationServiceAdapter;
import ibase.rest.model.application.v1.Application;
import ibase.rest.model.application.v1.ApplicationsdocumentationSummary;
import ibase.rest.model.application.v1.InlineResponse200;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.StreamingOutput;

public class ApplicationsApiServiceImpl
extends ApplicationsApiService {
    public static final String RESOURCE_BUNDLE = "language.ApplicationsApi";
    private static final Logger logger = Logger.getLogger("ApplicationsApi");

    private ResourceBundle getBundle(String localeString) {
        Locale locale = ServiceUtil.getLocale((String)localeString);
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, locale, this.getClass().getClassLoader());
        return bundle;
    }

    @Override
    public Response applicationsApplicationIdGet(String applicationId, String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("applications.id.get.info", new String[0]));
        ApplicationServiceAdapter service = (ApplicationServiceAdapter)ServiceAdapter.getInstance(ApplicationServiceAdapter.class, (String)locale);
        Optional<Application> application = service.getApplication(applicationId);
        if (application.isPresent()) {
            return Response.ok().entity((Object)application.get()).build();
        }
        return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("applications.id.not.found", new String[]{applicationId}));
    }

    @Override
    public Response applicationsApplicationIdDocumentationDownloadGet(String applicationId, String fileName, String locale, SecurityContext securityContext) throws NotFoundException {
        if (fileName == null) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("application.fileName.empty", new String[0]));
        }
        ApplicationServiceAdapter service = (ApplicationServiceAdapter)ServiceAdapter.getInstance(ApplicationServiceAdapter.class, (String)locale);
        final InputStream is = service.getApplicationDocFileStream(applicationId, fileName);
        if (is == null) {
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("application.doc.not.found", new String[0]));
        }
        StreamingOutput output = new StreamingOutput(){

            public void write(OutputStream out) throws IOException {
                int length;
                byte[] buffer = new byte[1024];
                while ((length = is.read(buffer)) != -1) {
                    out.write(buffer, 0, length);
                }
                out.flush();
                is.close();
            }
        };
        String mimeType = null;
        try {
            mimeType = Files.probeContentType(new File(fileName).toPath());
        }
        catch (IOException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("application.doc.not.found", new String[0]));
        }
        return Response.ok((Object)output).type(mimeType != null ? mimeType : "application/octet-stream").header("Content-Disposition", (Object)("filename=\"" + fileName + "\"")).build();
    }

    @Override
    public Response applicationsGet(String name, String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("applications.get.info", new String[0]));
        ApplicationServiceAdapter service = (ApplicationServiceAdapter)ServiceAdapter.getInstance(ApplicationServiceAdapter.class, (String)locale);
        List<Application> applications = name != null ? service.getApplications(a -> a.getName().toUpperCase().startsWith(name.toUpperCase())) : service.getApplications(null);
        return Response.ok().entity(applications).build();
    }

    @Override
    public Response applicationsDocumentationGet(String locale, SecurityContext securityContext) throws NotFoundException {
        ApplicationServiceAdapter service = (ApplicationServiceAdapter)ServiceAdapter.getInstance(ApplicationServiceAdapter.class, (String)locale);
        List<Application> applications = service.getApplications(null);
        ArrayList<InlineResponse200> responseList = new ArrayList<InlineResponse200>();
        for (Application app : applications) {
            String appId = app.getId();
            String fileName = "page.json";
            InputStream fileStream = service.getApplicationDocFileStream(appId, fileName);
            InlineResponse200 response = new InlineResponse200();
            response.setId(appId);
            ApplicationsdocumentationSummary responseSummary = new ApplicationsdocumentationSummary();
            ObjectMapper mapper = new ObjectMapper();
            if (fileStream == null) continue;
            try {
                Map map = (Map)mapper.readValue(fileStream, (TypeReference)new TypeReference<Map<String, Object>>(){});
                Object ptLang = map.get("pt");
                if (ptLang != null) {
                    Map mapEnLang;
                    Object enSummary;
                    Object enLang;
                    Object ptSummary;
                    Object download;
                    Object name;
                    Map mapPtLang = (Map)ptLang;
                    Object icon = mapPtLang.get("icon");
                    if (icon != null) {
                        response.setIcon((String)icon);
                    }
                    if ((name = mapPtLang.get("name")) != null) {
                        response.setName((String)name);
                    }
                    if ((download = mapPtLang.get("download")) != null) {
                        List mapPtLangDownloadList = (List)download;
                        ArrayList<String> versionIds = new ArrayList<String>();
                        for (Map downloadElem : mapPtLangDownloadList) {
                            Map linkMap;
                            Object versionId;
                            Object link = downloadElem.get("link");
                            if (link == null || (versionId = (linkMap = (Map)link).get("versionId")) == null) continue;
                            versionIds.add((String)versionId);
                        }
                        response.setVersion(service.getApplicationLatestVersion(versionIds));
                    }
                    if ((ptSummary = mapPtLang.get("summary")) != null) {
                        responseSummary.setPt((String)ptSummary);
                    }
                    if ((enLang = map.get("en")) != null && (enSummary = (mapEnLang = (Map)enLang).get("summary")) != null) {
                        responseSummary.setEn((String)enSummary);
                    }
                    response.setSummary(responseSummary);
                    Object owner = mapPtLang.get("authors");
                    if (owner != null) {
                        response.setOwner((List)owner);
                    }
                }
                responseList.add(response);
            }
            catch (JsonParseException e) {
                logger.log(Level.SEVERE, "Erro no download de documenta\u00e7\u00e3o da aplica\u00e7\u00e3o " + appId, e);
            }
            catch (JsonMappingException e) {
                logger.log(Level.SEVERE, "Erro no download de documenta\u00e7\u00e3o da aplica\u00e7\u00e3o " + appId, e);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Erro no download de documenta\u00e7\u00e3o da aplica\u00e7\u00e3o " + appId, e);
            }
        }
        return Response.ok(responseList).type("application/json").header("Content-Disposition", (Object)"filename=\" + applications\"").build();
    }
}

