/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.api.authentication.v1.impl;

import ibase.common.ServiceAdapter;
import ibase.common.ServiceUtil;
import ibase.common.User;
import ibase.rest.api.authentication.v1.AuthenticationApiService;
import ibase.rest.api.authentication.v1.NotFoundException;
import ibase.rest.api.authentication.v1.adapter.AuthenticationService;
import ibase.rest.api.authentication.v1.adapter.ParseException;
import ibase.rest.api.authentication.v1.adapter.UnauthorizedException;
import ibase.rest.api.authentication.v1.adapter.UserAlreadyExistsException;
import ibase.rest.api.authentication.v1.adapter.UserNotFoundException;
import ibase.rest.model.authentication.v1.Token;
import ibase.rest.model.authentication.v1.TokenValidation;
import java.io.Reader;
import java.io.StringReader;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.validator.routines.EmailValidator;

public class AuthenticationApiServiceImpl
extends AuthenticationApiService {
    private static final String FACEBOOK_URL = "https://graph.facebook.com/";
    private static final String APP_ID = "242678212780319";
    private static final String APP_NAME = "CSGridWeb";
    private static final String APP_TOKEN = "242678212780319|eBzQEJjLaJyD7EaTfIHxGA6mcvA";
    public static final String ATTRIBUTE_USER_EMAIL = "userEmail";
    public static final String ATTRIBUTE_USER_NAME = "userName";
    public static final String ATTRIBUTE_USER_PASSWORD = "userPassword";
    public static final String RESOURCE_BUNDLE = "language.AuthenticationApi";
    public static final String BEARER = "Bearer ";
    public static final String NEW_USER_VALIDATION = "new_user";
    public static final String NEW_PASSWORD_VALIDATION = "new_password";
    public static final String ACCESS_VALIDATION = "access";
    private static final Logger logger = Logger.getLogger("AuthenticationApi");

    private Token buildRestToken(String accessToken, ibase.rest.model.authentication.v1.User user) {
        Token token = new Token();
        token.setAccessToken(accessToken);
        token.setTokenType(BEARER);
        token.setUser(user);
        return token;
    }

    private ibase.rest.model.authentication.v1.User buildRestUser(String userId, String localeString, String accessToken, SecurityContext securityContext) {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(ServiceAdapter.getURI());
        Response response = target.path("users").path(userId).queryParam("locale", new Object[]{localeString}).request(new String[]{"application/json;charset=UTF-8"}).header("Authorization", (Object)(BEARER + accessToken)).get();
        if (response.getStatus() != 200) {
            return null;
        }
        ibase.rest.model.authentication.v1.User restUser = (ibase.rest.model.authentication.v1.User)response.readEntity(ibase.rest.model.authentication.v1.User.class);
        return restUser;
    }

    private static boolean verifyFacebookToken(String user_token, String app_token) {
        try {
            Client client = ClientBuilder.newClient();
            WebTarget target = client.target(FACEBOOK_URL).path("debug_token").queryParam("input_token", new Object[]{user_token}).queryParam("access_token", new Object[]{app_token});
            Invocation.Builder request = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
            Response response = request.get();
            if (response.getStatus() == 200) {
                StringReader stringReader = new StringReader((String)target.request(new String[]{"application/json"}).get(String.class));
                JsonReader jsonReader = Json.createReader((Reader)stringReader);
                JsonObject jObject = jsonReader.readObject();
                JsonObject data = jObject.getJsonObject("data");
                boolean isValid = data.getBoolean("is_valid");
                if (!isValid) {
                    return false;
                }
                String appId = data.getString("app_id");
                String appName = data.getString("application");
                return appName != null && appName.equals(APP_NAME) && appId != null && appId.equals(APP_ID);
            }
            return false;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static User buildFacebookUser(String user_token) throws Exception {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(FACEBOOK_URL).path("me").queryParam("fields", new Object[]{"name,email,picture"}).queryParam("access_token", new Object[]{user_token});
        Invocation.Builder request = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        Response response = request.get();
        if (response.getStatus() == 200) {
            StringReader stringReader = new StringReader((String)target.request(new String[]{"application/json"}).get(String.class));
            JsonReader jsonReader = Json.createReader((Reader)stringReader);
            JsonObject jObject = jsonReader.readObject();
            String email = jObject.getString("email");
            String name = jObject.getString("name");
            JsonObject picture = jObject.getJsonObject("picture");
            JsonObject pictureData = picture.getJsonObject("data");
            String avatarLink = pictureData.getString("url");
            String login = email;
            ArrayList<String> emails = new ArrayList<String>();
            emails.add(email);
            User user = new User(login, name, emails, null, avatarLink);
            return user;
        }
        return null;
    }

    private String buildUserValidationLink(String email, String userName, String password, String baseURL, String locale) throws UnauthorizedException {
        AuthenticationService authenticationService = (AuthenticationService)ServiceAdapter.getInstance(AuthenticationService.class, (String)locale);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put(ATTRIBUTE_USER_EMAIL, email);
        attributes.put(ATTRIBUTE_USER_NAME, userName);
        attributes.put(ATTRIBUTE_USER_PASSWORD, password);
        Instant now = Instant.now();
        Date expirationDate = Date.from(now.plus(Duration.ofDays(3650L)));
        StringBuilder builder = new StringBuilder();
        builder.append(baseURL);
        if (!baseURL.endsWith("/")) {
            builder.append("/");
        }
        builder.append("#!/login/");
        builder.append(authenticationService.createToken(email, attributes, expirationDate));
        return builder.toString();
    }

    private String buildNewPasswordValidationLink(String email, String baseURL, String locale) throws UnauthorizedException {
        AuthenticationService authenticationService = (AuthenticationService)ServiceAdapter.getInstance(AuthenticationService.class, (String)locale);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put(ATTRIBUTE_USER_EMAIL, email);
        Instant now = Instant.now();
        Date expirationDate = Date.from(now.plus(Duration.ofDays(3650L)));
        StringBuilder builder = new StringBuilder();
        builder.append(baseURL);
        if (!baseURL.endsWith("/")) {
            builder.append("/");
        }
        builder.append("#!/password/");
        builder.append(authenticationService.createToken(email, attributes, expirationDate));
        return builder.toString();
    }

    private ResourceBundle getBundle(String localeString) {
        Locale locale = ServiceUtil.getLocale((String)localeString);
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, locale, this.getClass().getClassLoader());
        return bundle;
    }

    @Override
    public Response authenticationPost(String login, String password, String locale, SecurityContext securityContext) throws NotFoundException {
        AuthenticationService authenticationService = (AuthenticationService)ServiceAdapter.getInstance(AuthenticationService.class, (String)locale);
        if (login == null || login.isEmpty() || password == null || password.isEmpty()) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("authentication.login.parameter.missing.error", new String[0]));
        }
        try {
            User user = authenticationService.login(login, password);
            Instant now = Instant.now();
            Date expirationDate = Date.from(now.plus(Duration.ofDays(3650L)));
            String accessToken = authenticationService.createToken(user.login, null, expirationDate);
            ibase.rest.model.authentication.v1.User restUser = this.buildRestUser(user.login, locale, accessToken, securityContext);
            if (restUser == null) {
                String msg = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("authentication.user.not.found", new String[]{user.login});
                return ServiceUtil.buildException((Response.Status)Response.Status.UNAUTHORIZED, (Logger)logger, (String)msg);
            }
            Token token = this.buildRestToken(accessToken, restUser);
            return Response.ok().entity((Object)token).build();
        }
        catch (UnauthorizedException e) {
            String msg = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("authentication.user.not.found", new String[]{login});
            return ServiceUtil.buildException((Response.Status)Response.Status.UNAUTHORIZED, (Logger)logger, (String)msg);
        }
        catch (Exception e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Logger)logger, (Exception)e);
        }
    }

    @Override
    public Response authenticationTokenValidationPost(String userToken, String validationType, String locale, SecurityContext securityContext) throws NotFoundException {
        if (userToken == null || userToken.isEmpty()) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("authentication.usertoken.parameter.missing.error", new String[0]));
        }
        if (validationType == null || validationType.isEmpty()) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("authentication.validationType.parameter.missing.error", new String[0]));
        }
        String tokenUserId = null;
        TokenValidation validation = new TokenValidation();
        validation.valid(true);
        validation.cause("");
        Hashtable<String, Object> attributes = new Hashtable<String, Object>();
        AuthenticationService authenticationService = (AuthenticationService)ServiceAdapter.getInstance(AuthenticationService.class, (String)locale);
        try {
            tokenUserId = authenticationService.parserToken(userToken, attributes);
        }
        catch (ParseException e) {
            validation.valid(false);
            validation.cause(e.getMessage());
            return Response.ok().entity((Object)validation).build();
        }
        boolean userFound = authenticationService.userExists(tokenUserId);
        switch (validationType = validationType.toLowerCase()) {
            case "new_user": {
                if (!userFound) break;
                validation.valid(false);
                validation.cause(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("authentication.user.validation.login.already.exists", new String[]{tokenUserId}));
                break;
            }
            case "new_password": 
            case "access": {
                if (userFound) break;
                validation.valid(false);
                validation.cause(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("authentication.user.not.found", new String[]{tokenUserId}));
            }
        }
        return Response.ok().entity((Object)validation).build();
    }

    @Override
    public Response authenticationNewuserValidationPost(String name, String email, String password, String baseURL, String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("authentication.user.validation.post", new String[]{email}));
        try {
            if (email == null || email.isEmpty()) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("authentication.user.validation.email.missing", new String[0]));
            }
            if (!this.isValidEmail(email)) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("authentication.newuser.validation.email.invalid", new String[]{email}));
            }
            if (name == null || name.isEmpty()) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("authentication.user.validation.name.missing", new String[0]));
            }
            if (password == null || password.isEmpty()) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("authentication.user.validation.password.missing", new String[0]));
            }
            if (baseURL == null || baseURL.isEmpty()) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("authentication.user.validation.baseurl.missing", new String[0]));
            }
            String link = this.buildUserValidationLink(email, name, password, baseURL, locale);
            AuthenticationService authenticationService = (AuthenticationService)ServiceAdapter.getInstance(AuthenticationService.class, (String)locale);
            authenticationService.validateNewUserByEmail(name, email, link);
            return Response.ok().build();
        }
        catch (UserAlreadyExistsException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("authentication.user.validation.login.already.exists", new String[]{email}));
        }
        catch (UnauthorizedException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.UNAUTHORIZED, (Logger)logger, (Exception)e);
        }
        catch (Exception e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Logger)logger, (Exception)e);
        }
    }

    private boolean isValidEmail(String email) {
        return EmailValidator.getInstance().isValid(email);
    }

    @Override
    public Response authenticationNewuserAcceptPost(String userToken, String locale, SecurityContext securityContext) throws NotFoundException {
        if (userToken == null || userToken.isEmpty()) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("authentication.usertoken.parameter.missing.error", new String[0]));
        }
        try {
            AuthenticationService authenticationService = (AuthenticationService)ServiceAdapter.getInstance(AuthenticationService.class, (String)locale);
            Instant now = Instant.now();
            Date expirationDate = Date.from(now.plus(Duration.ofDays(3650L)));
            User user = authenticationService.acceptNewUser(userToken);
            String accessToken = authenticationService.createToken(user.login, null, expirationDate);
            ibase.rest.model.authentication.v1.User restUser = this.buildRestUser(user.login, locale, accessToken, securityContext);
            if (restUser == null) {
                String msg = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("authentication.user.not.found", new String[]{user.login});
                return ServiceUtil.buildException((Response.Status)Response.Status.UNAUTHORIZED, (Logger)logger, (String)msg);
            }
            Token token = this.buildRestToken(accessToken, restUser);
            String notification = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("authentication.new.guest.user.msg", new String[]{user.login, user.name});
            authenticationService.notifySupport(notification);
            return Response.ok().entity((Object)token).build();
        }
        catch (UnauthorizedException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.UNAUTHORIZED, (Logger)logger, (Exception)e);
        }
        catch (Exception e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Logger)logger, (Exception)e);
        }
    }

    @Override
    public Response authenticationFacebookPost(String userToken, String locale, SecurityContext securityContext) throws NotFoundException {
        if (userToken == null || userToken.isEmpty()) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("authentication.fb.parameter.missing.error", new String[0]));
        }
        try {
            AuthenticationService authenticationService = (AuthenticationService)ServiceAdapter.getInstance(AuthenticationService.class, (String)locale);
            if (AuthenticationApiServiceImpl.verifyFacebookToken(userToken, APP_TOKEN)) {
                User user = AuthenticationApiServiceImpl.buildFacebookUser(userToken);
                String login = user.login;
                if ((user = authenticationService.updateUser(user)) == null) {
                    String msg = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("authentication.user.not.found", new String[]{login});
                    return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)msg);
                }
                Instant now = Instant.now();
                Date issuedDate = Date.from(now);
                Date expirationDate = Date.from(now.plus(Duration.ofDays(3650L)));
                String accessToken = authenticationService.createToken(user.login, null, expirationDate, issuedDate);
                ibase.rest.model.authentication.v1.User restUser = this.buildRestUser(user.login, locale, accessToken, securityContext);
                if (restUser == null) {
                    String msg = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("authentication.user.not.found", new String[]{user.login});
                    return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)msg);
                }
                Token token = this.buildRestToken(accessToken, restUser);
                return Response.ok().entity((Object)token).build();
            }
            String msg = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("authentication.facebook.error", new String[0]);
            return ServiceUtil.buildException((Response.Status)Response.Status.UNAUTHORIZED, (Logger)logger, (String)msg);
        }
        catch (UnauthorizedException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.UNAUTHORIZED, (Logger)logger, (Exception)e);
        }
        catch (Exception e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Logger)logger, (Exception)e);
        }
    }

    @Override
    public Response authenticationNewpasswordAcceptPost(String userToken, String password, String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("authentication.newpassword.accept.post", new String[0]));
        if (userToken == null || userToken.isEmpty()) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("authentication.usertoken.parameter.missing.error", new String[0]));
        }
        if (password == null || password.isEmpty()) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("authentication.newpassword.password.missing", new String[0]));
        }
        try {
            AuthenticationService authenticationService = (AuthenticationService)ServiceAdapter.getInstance(AuthenticationService.class, (String)locale);
            User user = authenticationService.acceptNewPassword(userToken, password);
            Instant now = Instant.now();
            Date issuedDate = Date.from(now);
            Date expirationDate = Date.from(now.plus(Duration.ofDays(3650L)));
            String accessToken = authenticationService.createToken(user.login, null, expirationDate, issuedDate);
            ibase.rest.model.authentication.v1.User restUser = this.buildRestUser(user.login, locale, accessToken, securityContext);
            if (restUser == null) {
                return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("authentication.user.not.found", new String[]{user.login}));
            }
            Token token = this.buildRestToken(accessToken, restUser);
            return Response.ok().entity((Object)token).build();
        }
        catch (UnauthorizedException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.UNAUTHORIZED, (Logger)logger, (Exception)e);
        }
        catch (Exception e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Logger)logger, (Exception)e);
        }
    }

    @Override
    public Response authenticationNewpasswordValidationPost(String email, String baseURL, String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("authentication.newpassword.validation.post", new String[]{email}));
        try {
            if (email == null || email.isEmpty()) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("authentication.newpassword.validation.email.missing", new String[0]));
            }
            if (!this.isValidEmail(email)) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("authentication.newuser.validation.email.invalid", new String[]{email}));
            }
            if (baseURL == null || baseURL.isEmpty()) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("authentication.newpassword.validation.baseurl.missing", new String[0]));
            }
            String link = this.buildNewPasswordValidationLink(email, baseURL, locale);
            AuthenticationService authenticationService = (AuthenticationService)ServiceAdapter.getInstance(AuthenticationService.class, (String)locale);
            authenticationService.validateNewPasswordByEmail(email, link);
            return Response.ok().build();
        }
        catch (UserNotFoundException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("authentication.newpassword.validation.user.invalid", new String[]{email}));
        }
        catch (UnauthorizedException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.UNAUTHORIZED, (Logger)logger, (Exception)e);
        }
        catch (Exception e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Logger)logger, (Exception)e);
        }
    }
}

