/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.model.algorithm.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import ibase.rest.model.algorithm.v1.Requirement;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AlgorithmVersion {
    private String id = null;
    private String description = null;
    private List<Requirement> requirements = new ArrayList<Requirement>();

    public AlgorithmVersion id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="An Unique identifier of an algorithm version.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AlgorithmVersion description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the algorithm version.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AlgorithmVersion requirements(List<Requirement> requirements) {
        this.requirements = requirements;
        return this;
    }

    @ApiModelProperty(value="The requirements of this version. This list can override or extend the algorithm requirements. The version requirements also include the supported platforms this version.")
    @JsonProperty(value="requirements")
    public List<Requirement> getRequirements() {
        return this.requirements;
    }

    public void setRequirements(List<Requirement> requirements) {
        this.requirements = requirements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlgorithmVersion algorithmVersion = (AlgorithmVersion)o;
        return Objects.equals(this.id, algorithmVersion.id) && Objects.equals(this.description, algorithmVersion.description) && Objects.equals(this.requirements, algorithmVersion.requirements);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.description, this.requirements);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlgorithmVersion {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    requirements: ").append(this.toIndentedString(this.requirements)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

