/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.model.algorithm.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import ibase.rest.model.algorithm.v1.Parameter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Configuration for the parameter of type boolean.")
public class BooleanParameter
extends Parameter {
    private String id = null;
    private String label = null;
    private String description = null;
    private Boolean optional = null;
    private Boolean hidden = null;
    private Boolean ignoreIfHidden = null;
    private Boolean ignoreIfDisabled = null;
    private Object defaultValue = null;
    private String trueValue = null;
    private String falseValue = null;

    @Override
    public BooleanParameter id(String id) {
        this.id = id;
        return this;
    }

    @Override
    @ApiModelProperty(required=true, value="The identification of the parameter.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public BooleanParameter label(String label) {
        this.label = label;
        return this;
    }

    @Override
    @ApiModelProperty(value="The label of the parameter.")
    @JsonProperty(value="label")
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public BooleanParameter description(String description) {
        this.description = description;
        return this;
    }

    @Override
    @ApiModelProperty(value="The parameter description.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public BooleanParameter optional(Boolean optional) {
        this.optional = optional;
        return this;
    }

    @Override
    @ApiModelProperty(value="If the paramenter is not mandatory.")
    @JsonProperty(value="optional")
    public Boolean getOptional() {
        return this.optional;
    }

    @Override
    public void setOptional(Boolean optional) {
        this.optional = optional;
    }

    @Override
    public BooleanParameter hidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Override
    @ApiModelProperty(value="If the paramenter is hidden.")
    @JsonProperty(value="hidden")
    public Boolean getHidden() {
        return this.hidden;
    }

    @Override
    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public BooleanParameter ignoreIfHidden(Boolean ignoreIfHidden) {
        this.ignoreIfHidden = ignoreIfHidden;
        return this;
    }

    @Override
    @ApiModelProperty(value="If the parameter is hidden, it must not be used as parameter for the algorithm execution.")
    @JsonProperty(value="ignore_if_hidden")
    public Boolean getIgnoreIfHidden() {
        return this.ignoreIfHidden;
    }

    @Override
    public void setIgnoreIfHidden(Boolean ignoreIfHidden) {
        this.ignoreIfHidden = ignoreIfHidden;
    }

    @Override
    public BooleanParameter ignoreIfDisabled(Boolean ignoreIfDisabled) {
        this.ignoreIfDisabled = ignoreIfDisabled;
        return this;
    }

    @Override
    @ApiModelProperty(value="If the parameter is disabled, it must not be used as parameter for the algorithm execution.")
    @JsonProperty(value="ignore_if_disabled")
    public Boolean getIgnoreIfDisabled() {
        return this.ignoreIfDisabled;
    }

    @Override
    public void setIgnoreIfDisabled(Boolean ignoreIfDisabled) {
        this.ignoreIfDisabled = ignoreIfDisabled;
    }

    @Override
    public BooleanParameter defaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @Override
    @ApiModelProperty(value="A json object that is the default value for this parameter. It depends of the parameter type.")
    @JsonProperty(value="default_value")
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public BooleanParameter trueValue(String trueValue) {
        this.trueValue = trueValue;
        return this;
    }

    @ApiModelProperty(value="The string to be used as the algorithm parameter when the value of this parameter is true.")
    @JsonProperty(value="true_value")
    public String getTrueValue() {
        return this.trueValue;
    }

    public void setTrueValue(String trueValue) {
        this.trueValue = trueValue;
    }

    public BooleanParameter falseValue(String falseValue) {
        this.falseValue = falseValue;
        return this;
    }

    @ApiModelProperty(value="The string to be used as the algorithm parameter when the value of this parameter is false.")
    @JsonProperty(value="false_value")
    public String getFalseValue() {
        return this.falseValue;
    }

    public void setFalseValue(String falseValue) {
        this.falseValue = falseValue;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BooleanParameter booleanParameter = (BooleanParameter)o;
        return Objects.equals(this.id, booleanParameter.id) && Objects.equals(this.label, booleanParameter.label) && Objects.equals(this.description, booleanParameter.description) && Objects.equals(this.optional, booleanParameter.optional) && Objects.equals(this.hidden, booleanParameter.hidden) && Objects.equals(this.ignoreIfHidden, booleanParameter.ignoreIfHidden) && Objects.equals(this.ignoreIfDisabled, booleanParameter.ignoreIfDisabled) && Objects.equals(this.defaultValue, booleanParameter.defaultValue) && Objects.equals(this.trueValue, booleanParameter.trueValue) && Objects.equals(this.falseValue, booleanParameter.falseValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.label, this.description, this.optional, this.hidden, this.ignoreIfHidden, this.ignoreIfDisabled, this.defaultValue, this.trueValue, this.falseValue);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BooleanParameter {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    optional: ").append(this.toIndentedString(this.optional)).append("\n");
        sb.append("    hidden: ").append(this.toIndentedString(this.hidden)).append("\n");
        sb.append("    ignoreIfHidden: ").append(this.toIndentedString(this.ignoreIfHidden)).append("\n");
        sb.append("    ignoreIfDisabled: ").append(this.toIndentedString(this.ignoreIfDisabled)).append("\n");
        sb.append("    defaultValue: ").append(this.toIndentedString(this.defaultValue)).append("\n");
        sb.append("    trueValue: ").append(this.toIndentedString(this.trueValue)).append("\n");
        sb.append("    falseValue: ").append(this.toIndentedString(this.falseValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

