/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.api.drmaa2.v1.impl;

import ibase.common.ServiceAdapter;
import ibase.common.ServiceUtil;
import ibase.exception.InternalServiceException;
import ibase.rest.api.drmaa2.v1.Drmaa2ApiService;
import ibase.rest.api.drmaa2.v1.NotFoundException;
import ibase.rest.api.drmaa2.v1.adapter.Drmaa2ServiceAdapter;
import ibase.rest.model.drmaa2.v1.InlineResponse200;
import ibase.rest.model.drmaa2.v1.Job;
import ibase.rest.model.drmaa2.v1.JobSession;
import ibase.rest.model.drmaa2.v1.JobTemplate;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.StreamingOutput;

public class Drmaa2ApiServiceImpl
extends Drmaa2ApiService {
    public static final String RESOURCE_BUNDLE = "language.Drmaa2Api";
    private static final Logger logger = Logger.getLogger("Drmaa2Api");

    private ResourceBundle getBundle(String localeString) {
        Locale locale = ServiceUtil.getLocale((String)localeString);
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, locale, this.getClass().getClassLoader());
        return bundle;
    }

    @Override
    public Response drmaa2JobPost(String jobSessionId, JobTemplate jobTemplate, String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("drmaa2JobPost.info", new String[0]));
        try {
            Drmaa2ServiceAdapter service = (Drmaa2ServiceAdapter)ServiceAdapter.getInstance(Drmaa2ServiceAdapter.class, (String)locale);
            String jobId = service.runJob(jobSessionId, jobTemplate);
            return Response.ok().entity((Object)jobId).type("text/plain").build();
        }
        catch (InternalServiceException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Logger)logger, (Exception)((Object)e));
        }
    }

    @Override
    public Response drmaa2JobsessionGet(String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("drmaa2JobsessionGet.info", new String[0]));
        try {
            Drmaa2ServiceAdapter service = (Drmaa2ServiceAdapter)ServiceAdapter.getInstance(Drmaa2ServiceAdapter.class, (String)locale);
            List<JobSession> jobSessions = service.getAllJobSessions();
            return Response.ok().entity(jobSessions).build();
        }
        catch (InternalServiceException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Logger)logger, (Exception)((Object)e));
        }
    }

    @Override
    public Response drmaa2JobsessionJobSessionNameGet(String jobSessionName, String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("drmaa2JobsessionJobSessionNameGet.info", new String[0]));
        try {
            Drmaa2ServiceAdapter service = (Drmaa2ServiceAdapter)ServiceAdapter.getInstance(Drmaa2ServiceAdapter.class, (String)locale);
            JobSession jobSession = service.getJobSession(jobSessionName);
            return Response.ok().entity((Object)jobSession).build();
        }
        catch (InternalServiceException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Logger)logger, (Exception)((Object)e));
        }
    }

    @Override
    public Response drmaa2JobsessionPost(String name, String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("drmaa2JobsessionPost.info", new String[0]));
        try {
            Drmaa2ServiceAdapter service = (Drmaa2ServiceAdapter)ServiceAdapter.getInstance(Drmaa2ServiceAdapter.class, (String)locale);
            JobSession jobSession = service.createJobSession(name);
            return Response.ok().entity((Object)jobSession).build();
        }
        catch (InternalServiceException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Logger)logger, (Exception)((Object)e));
        }
    }

    @Override
    public Response drmaa2JobGet(String projectId, Long modifiedAfter, String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("drmaa2JobGet.info", new String[0]));
        try {
            Drmaa2ServiceAdapter service = (Drmaa2ServiceAdapter)ServiceAdapter.getInstance(Drmaa2ServiceAdapter.class, (String)locale);
            List<Job> jobs = service.getJobs(projectId, modifiedAfter);
            InlineResponse200 response = new InlineResponse200();
            response.setProcessingDate(System.currentTimeMillis());
            response.setJobs(jobs);
            return Response.ok().entity((Object)response).build();
        }
        catch (InternalServiceException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Logger)logger, (Exception)((Object)e));
        }
    }

    @Override
    public Response drmaa2JobJobIdGet(String jobId, String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("drmaa2JobJobIdGet.info", new String[0]));
        try {
            Drmaa2ServiceAdapter service = (Drmaa2ServiceAdapter)ServiceAdapter.getInstance(Drmaa2ServiceAdapter.class, (String)locale);
            Job job = service.getJob(jobId);
            return Response.ok().entity((Object)job).build();
        }
        catch (InternalServiceException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Logger)logger, (Exception)((Object)e));
        }
    }

    @Override
    public Response drmaa2JobJobIdLogGet(String jobId, String locale, SecurityContext securityContext) throws NotFoundException {
        try {
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("drmaa2JobJobIdLogGet", new String[0]));
            Drmaa2ServiceAdapter service = (Drmaa2ServiceAdapter)ServiceAdapter.getInstance(Drmaa2ServiceAdapter.class, (String)locale);
            if (jobId == null || service.getJob(jobId) == null) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("job.id.invalid", new String[0]));
            }
            final StringBuffer stringBuffer = service.getLogFile(jobId);
            if (stringBuffer == null) {
                return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("job.log.not.found", new String[0]));
            }
            StreamingOutput output = new StreamingOutput(){

                public void write(OutputStream out) throws IOException {
                    out.write(stringBuffer.toString().getBytes());
                    out.flush();
                    out.close();
                }
            };
            return Response.ok((Object)output).build();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("user.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }
}

