/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.api.drmaa2.v1;

import ibase.rest.api.drmaa2.v1.Drmaa2ApiService;
import ibase.rest.api.drmaa2.v1.NotFoundException;
import ibase.rest.api.drmaa2.v1.factories.Drmaa2ApiServiceFactory;
import ibase.rest.model.drmaa2.v1.Job;
import ibase.rest.model.drmaa2.v1.JobSession;
import ibase.rest.model.drmaa2.v1.JobTemplate;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/drmaa2")
@Produces(value={"application/json;"})
@Api(description="the drmaa2 API")
public class Drmaa2Api {
    private final Drmaa2ApiService delegate = Drmaa2ApiServiceFactory.getDrmaa2Api();

    @POST
    @Path(value="/job")
    @Produces(value={"application/json;"})
    @ApiOperation(value="Create a job.", notes="This endpoint submits a job for execution,", response=Job.class, tags={"Jobs"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation.", response=Job.class)})
    public Response drmaa2JobPost(@ApiParam(value="The ID of the job session. This parameter is mandatory.", required=true) @QueryParam(value="jobSessionId") String jobSessionId, @ApiParam(value="The job template") JobTemplate jobTemplate, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.drmaa2JobPost(jobSessionId, jobTemplate, locale, securityContext);
    }

    @GET
    @Path(value="/jobsession")
    @Produces(value={"application/json;"})
    @ApiOperation(value="Get a list of all job sessions the authenticated user can access.", notes="This endpoint return a list of URIs to all available job sessions. A job session instance acts as container for job instances.", response=JobSession.class, responseContainer="List", tags={"Jobs"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation.", response=JobSession.class, responseContainer="List")})
    public Response drmaa2JobsessionGet(@ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.drmaa2JobsessionGet(locale, securityContext);
    }

    @GET
    @Path(value="/jobsession/{jobSessionName}")
    @Produces(value={"application/json;"})
    @ApiOperation(value="Get a job session by its name", notes="This endpoint returns a job session by its name. The name is encoded in Base64.", response=JobSession.class, tags={"Jobs"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=JobSession.class), @ApiResponse(code=404, message="Job session was not found.", response=JobSession.class)})
    public Response drmaa2JobsessionJobSessionNameGet(@ApiParam(value="The name of a job session encoded in Base64.", required=true) @PathParam(value="jobSessionName") String jobSessionName, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.drmaa2JobsessionJobSessionNameGet(jobSessionName, locale, securityContext);
    }

    @POST
    @Path(value="/jobsession")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;"})
    @ApiOperation(value="Create a job session.", notes="This endpoint creates a job session.", response=JobSession.class, responseContainer="List", tags={"Jobs"})
    @ApiResponses(value={@ApiResponse(code=201, message="The new job session was succesfully created.", response=JobSession.class, responseContainer="List"), @ApiResponse(code=400, message="If the name is empty or if the user already has a job session with the same name", response=JobSession.class, responseContainer="List"), @ApiResponse(code=415, message="Unsupported Media Type", response=JobSession.class, responseContainer="List")})
    public Response drmaa2JobsessionPost(@ApiParam(value="The name of the job session to be created. This parameter is mandatory.", required=true) @FormParam(value="name") String name, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @FormParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.drmaa2JobsessionPost(name, locale, securityContext);
    }
}

