/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.api.user.v1.impl;

import ibase.authentication.AuthenticationService;
import ibase.authentication.ParseException;
import ibase.common.ServiceAdapter;
import ibase.common.ServiceUtil;
import ibase.rest.api.user.v1.UsersApiService;
import ibase.rest.api.user.v1.impl.UsersApiServiceImpl;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/links")
@Produces(value={"application/json;"})
public class LinksApi {
    public static final String RESOURCE_BUNDLE = "language.LinksApi";
    private static final Logger logger = Logger.getLogger("LinksApi");

    private ResourceBundle getBundle(String localeString) {
        Locale locale = ServiceUtil.getLocale((String)localeString);
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, locale, this.getClass().getClassLoader());
        return bundle;
    }

    @GET
    @Path(value="/avatar/{token}")
    @Produces(value={"image/gif"})
    public Response linksTokenAvatarGet(@PathParam(value="token") String token, @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) {
        try {
            AuthenticationService authenticationService = (AuthenticationService)ServiceAdapter.getInstance(AuthenticationService.class, (String)locale);
            HashMap attributes = new HashMap();
            authenticationService.parserToken(token, attributes);
            String userId = attributes.get("userId").toString();
            UsersApiServiceImpl service = new UsersApiServiceImpl();
            return ((UsersApiService)service).usersUserIdPhotoGet(userId, locale, securityContext);
        }
        catch (ParseException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.FORBIDDEN, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("links.token.invalid", new String[0]));
        }
        catch (Throwable e) {
            throw new InternalServerErrorException(e);
        }
    }
}

