/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.api.user.v1.impl;

import ibase.authentication.AuthenticationService;
import ibase.authentication.UnauthorizedException;
import ibase.common.ServiceAdapter;
import ibase.common.ServiceUtil;
import ibase.rest.api.user.v1.NotFoundException;
import ibase.rest.api.user.v1.UsersApiService;
import ibase.rest.api.user.v1.adapter.User;
import ibase.rest.api.user.v1.adapter.UserService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.StreamingOutput;

public class UsersApiServiceImpl
extends UsersApiService {
    public static final String RESOURCE_BUNDLE = "language.UsersApi";
    public static final String ATTRIBUTE_USER_ID = "userId";
    public static final String ADMIN_ROLE = "admin";
    public static final String GUEST_ROLE = "guest";
    private static final Logger logger = Logger.getLogger("UsersApi");

    private ResourceBundle getBundle(String localeString) {
        Locale locale = ServiceUtil.getLocale((String)localeString);
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, locale, this.getClass().getClassLoader());
        return bundle;
    }

    private String buildAvatarLink(Object userId, String locale) throws UnauthorizedException {
        AuthenticationService authenticationService = (AuthenticationService)ServiceAdapter.getInstance(AuthenticationService.class, (String)locale);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put(ATTRIBUTE_USER_ID, userId);
        Calendar c = Calendar.getInstance();
        c.add(1, 10);
        StringBuilder builder = new StringBuilder();
        builder.append(ServiceAdapter.getURI());
        builder.append("/links/avatar/");
        builder.append(authenticationService.createToken(ServiceAdapter.getCurrenUser(), attributes, c.getTime()));
        return builder.toString();
    }

    private List<String> buildUserRoles(User user) {
        ArrayList<String> roles = new ArrayList<String>();
        if (user.isAdmin()) {
            roles.add(ADMIN_ROLE);
        }
        if (user.isGuest()) {
            roles.add(GUEST_ROLE);
        }
        return roles;
    }

    @Override
    public Response usersGet(String filter, String locale, SecurityContext securityContext) {
        try {
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("users.get.all.users.info", new String[0]));
            UserService userService = (UserService)ServiceAdapter.getInstance(UserService.class, (String)locale);
            List<User> allUsers = userService.getAllUsers();
            ArrayList<ibase.rest.model.user.v1.User> users = new ArrayList<ibase.rest.model.user.v1.User>();
            for (User user : allUsers) {
                if (filter != null && (filter == null || filter.trim().equals("") || (user.getName() == null || user.getName().toLowerCase().indexOf(filter.toLowerCase()) < 0) && (user.getLogin() == null || user.getLogin().toLowerCase().indexOf(filter.toLowerCase()) < 0))) continue;
                ibase.rest.model.user.v1.User restUser = new ibase.rest.model.user.v1.User();
                restUser.setId(user.getId());
                restUser.setLogin(user.getLogin());
                restUser.setName(user.getName());
                restUser.setRoles(this.buildUserRoles(user));
                String userPhotoLink = user.getPhotoLink();
                if (user.getPhotoLink() != null) {
                    restUser.setAvatar(userPhotoLink);
                } else if (userService.getUserPhotoFile(user.getId()) != null) {
                    restUser.setAvatar(this.buildAvatarLink(user.getId(), locale));
                }
                users.add(restUser);
            }
            return Response.ok().entity(users).build();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("user.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response usersUserIdPhotoGet(String userId, String locale, SecurityContext securityContext) throws NotFoundException {
        try {
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("users.get.photo.info", new String[]{userId}));
            UserService userService = (UserService)ServiceAdapter.getInstance(UserService.class, (String)locale);
            if (userId == null || userService.getUser(userId) == null) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("users.id.invalid", new String[0]));
            }
            File file = userService.getUserPhotoFile(userId);
            if (file == null) {
                return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("users.photo.not.found", new String[0]));
            }
            final FileInputStream is = new FileInputStream(file);
            StreamingOutput output = new StreamingOutput(){

                public void write(OutputStream out) throws IOException {
                    int length;
                    byte[] buffer = new byte[1024];
                    while ((length = is.read(buffer)) != -1) {
                        out.write(buffer, 0, length);
                    }
                    out.flush();
                    is.close();
                }
            };
            return Response.ok((Object)output).build();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("user.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException((Throwable)e);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("user.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response usersUserIdGet(String userId, String locale, SecurityContext securityContext) {
        try {
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("users.get.id.info", new String[]{userId}));
            UserService userService = (UserService)ServiceAdapter.getInstance(UserService.class, (String)locale);
            if (userId == null) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("users.id.invalid", new String[0]));
            }
            User user = userService.getUser(userId);
            if (user == null) {
                return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("users.id.not.found", new String[]{userId}));
            }
            ibase.rest.model.user.v1.User restUser = new ibase.rest.model.user.v1.User();
            restUser.setId(user.getId().toString());
            restUser.setLogin(user.getLogin());
            restUser.setName(user.getName());
            restUser.setRoles(this.buildUserRoles(user));
            String userPhotoLink = user.getPhotoLink();
            if (user.getPhotoLink() != null) {
                restUser.setAvatar(userPhotoLink);
            } else if (userService.getUserPhotoFile(user.getId()) != null) {
                restUser.setAvatar(this.buildAvatarLink(user.getId(), locale));
            }
            return Response.ok((Object)restUser).build();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("user.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }
}

