package tecgraf.javautils.gui.table;

import java.awt.Component;
import java.io.*;
import java.util.Vector;

import javax.swing.*;
import javax.swing.table.TableCellRenderer;

/**
 * Classe para renderizao do cabealho das colunas da tabela. O desenho
 * do cabealho ser feito no mnimo em duas linhas.
 *
 */
public class MultiLineHeaderRenderer extends JList
  implements TableCellRenderer {
	private static final long serialVersionUID = 1L;

	public MultiLineHeaderRenderer() {
    setOpaque(true);
    setForeground(UIManager.getColor("TableHeader.foreground"));
    setBackground(UIManager.getColor("TableHeader.background"));
    setBorder(UIManager.getBorder("TableHeader.cellBorder"));
    ListCellRenderer renderer = getCellRenderer();
    ((JLabel)renderer).setHorizontalAlignment(JLabel.CENTER);
    setCellRenderer(renderer);
  }

  public Component getTableCellRendererComponent(
    JTable table, Object value, boolean isSelected, boolean hasFocus, int row,
    int column) {
    int lines = 0;
    setFont(table.getFont());
    String str = (value == null) ? "" : value.toString();
    BufferedReader br = new BufferedReader(new StringReader(str));
    String line;
    Vector v = new Vector();
    try {
      while ((line = br.readLine()) != null) {
        v.addElement(line);
        lines++;
      }
      // Garante que o header tenha no mnimo duas linhas, e tenha espao
      // suficiente para o corner.
      if (lines<2)
        v.addElement(" ");
    }
    catch (IOException ex) {
      ex.printStackTrace();
    }
    setListData(v);
    return this;
  }
}	
