package tecgraf.javautils.gui.crud.gui.table;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;

import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

import tecgraf.javautils.gui.crud.IRegistrationDescriptor;
import tecgraf.javautils.gui.crud.gui.actions.RegistrationObjectAction;
import tecgraf.javautils.gui.crud.gui.main.RegistrationMainPanel;
import tecgraf.javautils.gui.crud.gui.main.RegistrationMainPanel.Mode;

/**
 * Listener de mouse de um {@link RegistrationTablePanel}.
 * 
 * @author Tecgraf
 * @param <M> tipo de objeto do modelo.
 * @param <I> tipo de objeto da interface.
 */
public class RegistrationTableMouseListener<M, I> extends MouseAdapter {

  /**
   * Painel associado.
   */
  final private RegistrationTablePanel<M, I> tablePanel;

  /**
   * Descritor
   */
  final private IRegistrationDescriptor<M, I> descriptor;

  /**
   * Exibe menu popup.
   * 
   * @param e evento
   */
  private void tryPopupMenu(MouseEvent e) {
    if (e.getButton() != MouseEvent.BUTTON3) {
      return;
    }
    if (!e.isPopupTrigger()) {
      return;
    }

    final Object source = e.getSource();
    final JTable table = (JTable) source;
    if (!table.isEnabled()) {
      return;
    }
    final M selectedObject = tablePanel.getSelectedObject();
    final RegistrationMainPanel<M, I> mainPanel = tablePanel.getMainPanel();
    final List<RegistrationObjectAction<M, I>> actions =
      descriptor.getPopupMenuActions(mainPanel, selectedObject);

    final JPopupMenu menu = new JPopupMenu();
    if (actions != null && actions.size() > 0) {
      for (AbstractAction action : actions) {
        menu.add(action);
      }
    }

    menu.show(tablePanel, e.getX(), e.getY());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void mouseClicked(MouseEvent e) {
    tryPopupMenu(e);
    // Comentado por compatibilidade inicial com o Infogrid.
    // tryEdtion(e);
  }

  /**
   * Tentativa de edio do objeto.
   * 
   * @param e evento
   */
  @SuppressWarnings("unused")
  private void tryEdtion(MouseEvent e) {
    if (e.getClickCount() != 2) {
      return;
    }
    if (e.getButton() != MouseEvent.BUTTON1) {
      return;
    }
    final Object source = e.getSource();
    final JTable table = (JTable) source;
    if (!table.isEnabled()) {
      return;
    }
    final RegistrationMainPanel<M, I> mainPanel = tablePanel.getMainPanel();
    mainPanel.setMode(Mode.EDIT);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void mousePressed(MouseEvent e) {
    tryPopupMenu(e);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void mouseReleased(MouseEvent e) {
    tryPopupMenu(e);
  }

  /**
   * Construtor
   * 
   * @param tablePanel painel.
   * @param descriptor descritor
   */
  RegistrationTableMouseListener(RegistrationTablePanel<M, I> tablePanel,
    IRegistrationDescriptor<M, I> descriptor) {
    this.tablePanel = tablePanel;
    this.descriptor = descriptor;
  }

}
