/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.colorbutton;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import tecgraf.javautils.gui.colorbutton.ColorButtonChoiceListener;

public class ColorButton
extends JButton {
    private final List<ColorButtonChoiceListener> listeners = new ArrayList<ColorButtonChoiceListener>();
    private Component owner;

    private final void adjustColorButton(final ColorButton colorButton) {
        colorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color oldColor = colorButton.getBackground();
                Color newColor = JColorChooser.showDialog(ColorButton.this.owner, "", oldColor);
                if (newColor == null) {
                    newColor = oldColor;
                }
                colorButton.setBackground(newColor);
                for (int i = 0; i < ColorButton.this.listeners.size(); ++i) {
                    ColorButtonChoiceListener lst = (ColorButtonChoiceListener)ColorButton.this.listeners.get(i);
                    if (lst == null) continue;
                    lst.colorChosen(colorButton, newColor);
                }
            }
        });
    }

    public final Color getColor() {
        return this.getBackground();
    }

    public final void setColor(Color color) {
        this.setBackground(color);
    }

    public final void addColorButtonChoiceListener(ColorButtonChoiceListener listener) {
        this.listeners.add(listener);
    }

    public ColorButton() {
        super(" ");
        this.adjustColorButton(this);
    }

    public ColorButton(Color color) {
        this(null, color);
    }

    public ColorButton(Component owner, Color color) {
        super(" ");
        this.owner = owner;
        this.setBackground(color);
        this.adjustColorButton(this);
    }
}

