/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.tree;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import tecgraf.javautils.gui.tree.Filter;
import tecgraf.javautils.gui.tree.Node;

public final class Tree
extends JTree {
    private Filter filter;
    private Map<Node, List<Node>> visibleChildrenByParentNode;
    private Node root;

    public Tree(Node root, Filter filter) {
        if (root == null) {
            throw new IllegalArgumentException("O par\u00e2metro root est\u00e1 nulo.");
        }
        this.root = root;
        if (filter == null) {
            throw new IllegalArgumentException("O par\u00e2metro filter est\u00e1 nulo.");
        }
        this.filter = filter;
        this.visibleChildrenByParentNode = new HashMap<Node, List<Node>>();
        this.setShowsRootHandles(true);
        this.setModel(this.createTreeModel());
        this.setCellRenderer(this.createCellRenderer());
        this.filter();
    }

    public void filter() {
        this.visibleChildrenByParentNode.clear();
        this.populateVisibleChildrenByParentNode(this.root);
        MyTreeModel tModel = (MyTreeModel)this.getModel();
        tModel.fireStructuredChanged();
        if (this.filter.isEnabled()) {
            this.collapsePath(this.getTreePath(this.root));
            this.updateTreeExpandableStatus(this.root);
        }
    }

    private boolean accept(Node node) {
        if (!this.filter.isEnabled()) {
            return true;
        }
        block4: for (Node currentNode = node; currentNode != null; currentNode = currentNode.getParent()) {
            switch (currentNode.getFiltrageMode()) {
                case EVALUATE: {
                    if (!this.filter.isAccepted(currentNode)) continue block4;
                    return true;
                }
                case IGNORE: {
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("Modo de filtragem inesperado: " + (Object)((Object)currentNode.getFiltrageMode()));
                }
            }
        }
        return false;
    }

    private DefaultTreeCellRenderer createCellRenderer() {
        return new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selectedItems, boolean expanded, boolean leaf, int row, boolean focusFlag) {
                super.getTreeCellRendererComponent(tree, value, selectedItems, expanded, leaf, row, focusFlag);
                Node node = (Node)value;
                String label = node.getLabel();
                if (label == null) {
                    label = "";
                }
                this.setText(label);
                Icon icon = node.getIcon();
                if (icon != null) {
                    this.setIcon(icon);
                }
                return this;
            }
        };
    }

    private TreeModel createTreeModel() {
        return new MyTreeModel();
    }

    private TreePath getTreePath(Node node) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Node currentNode = node; currentNode != null; currentNode = currentNode.getParent()) {
            nodes.add(currentNode);
        }
        Collections.reverse(nodes);
        TreePath path = new TreePath(nodes.toArray());
        return path;
    }

    private boolean populateVisibleChildrenByParentNode(Node node) {
        LinkedList<Node> visibleChildren = new LinkedList<Node>();
        for (Node node2 : node.getChildren()) {
            if (!this.populateVisibleChildrenByParentNode(node2)) continue;
            visibleChildren.add(node2);
        }
        if (!this.accept(node) && visibleChildren.isEmpty()) {
            return false;
        }
        this.visibleChildrenByParentNode.put(node, visibleChildren);
        return true;
    }

    private void updateTreeExpandableStatus(Node node) {
        TreePath treePath = this.getTreePath(node);
        for (Node node2 : node.getChildren()) {
            if (!this.filter.isAccepted(node2)) continue;
            this.expandPath(treePath);
            break;
        }
        for (Node node3 : node.getChildren()) {
            this.updateTreeExpandableStatus(node3);
        }
    }

    private final class MyTreeModel
    implements TreeModel {
        private List<TreeModelListener> listeners = new LinkedList<TreeModelListener>();

        private MyTreeModel() {
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public Object getChild(Object parent, int index) {
            List children = (List)Tree.this.visibleChildrenByParentNode.get(parent);
            if (children == null) {
                return null;
            }
            return children.get(index);
        }

        @Override
        public int getChildCount(Object parent) {
            List children = (List)Tree.this.visibleChildrenByParentNode.get(parent);
            if (children == null) {
                return 0;
            }
            return children.size();
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            List children = (List)Tree.this.visibleChildrenByParentNode.get(parent);
            if (children == null) {
                return -1;
            }
            return children.indexOf(child);
        }

        @Override
        public Node getRoot() {
            return Tree.this.root;
        }

        @Override
        public boolean isLeaf(Object current) {
            Node currentNode = (Node)current;
            return currentNode.getChildren().isEmpty();
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.listeners.remove(l);
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        void fireStructuredChanged() {
            for (TreeModelListener listener : this.listeners) {
                listener.treeStructureChanged(new TreeModelEvent((Object)Tree.this, new TreePath(Tree.this.root)));
            }
        }
    }
}

