/*
 * $Id: PrintConfiguration.java 66097 2007-08-06 13:43:36Z letnog $
 */
package tecgraf.javautils.gui.print;

/**
 * Classe com as configuraes de impresso.
 * 
 * - proporo de fonte: valor que multiplica o tamanho da fonte. O valor
 *     default  1 (mantm o tamanho original).
 * - indicador de quebra de tabela : indica se deve ou no quebrar a tabela se 
 *     ela no couber na pgina. Sempre imprime da segunda vez, mesmo que no 
 *     caiba e tenha a indicao de no quebrar, pois a tabela pode no caber 
 *     na pgina inteira. O valor default  verdadeiro.
 */
public class PrintConfiguration {
  /** Proporo da fonte a ser impressa */
  private float fontRate;
  /** Indicador se as tabelas devem ser quebradas */
  private boolean tableBreak;
  
  /**
   * Construtor.
   */
  public PrintConfiguration() {
    this(1, true);
  }
  
  /**
   * Construtor.
   * 
   * @param fontRate proporo da fonte a ser impressa.
   */
  public PrintConfiguration(float fontRate) {
    this(fontRate, true);
  }
  
  /**
   * Construtor.
   * 
   * @param fontRate proporo da fonte a ser impressa.
   * @param tableBreak indicador se as tabelas devem ser quebradas.
   */
  public PrintConfiguration(float fontRate, boolean tableBreak) {
    this.fontRate = fontRate;
    this.tableBreak = tableBreak;
  }

  /**
   * Obtm a proporo da fonte a ser impressa.
   * 
   * @return proporo da fonte a ser impressa.
   */
  public float getFontRate() {
    return fontRate;
  }

  /**
   * Indica se as tabelas devem ser quebradas.
   * @return verdadeiro se as tabelas devem ser quebradas.
   */
  public boolean isTableBreak() {
    return tableBreak;
  }
}
