/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIResources;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.SwingThreadDispatcher;
import tecgraf.javautils.gui.wizard.FollowStepPanel;
import tecgraf.javautils.gui.wizard.History;
import tecgraf.javautils.gui.wizard.Step;
import tecgraf.javautils.gui.wizard.StepGroup;
import tecgraf.javautils.gui.wizard.StepListener;
import tecgraf.javautils.gui.wizard.WizardException;
import tecgraf.javautils.gui.wizard.WizardListener;

public final class Wizard
extends JPanel {
    static final String LNG_KEY_PREFFIX = Wizard.class.getName() + ".";
    private int minimum_width = 700;
    private int minimum_height = 250;
    private JButton cancelButton;
    private JButton closeButton;
    private JButton confirmButton;
    private JButton nextButton;
    private JButton previousButton;
    private final JLabel stepTitleLabel = new JLabel();
    private final JTextArea stepInstructionTextArea = new JTextArea();
    private History history;
    private Set<WizardListener> listeners;
    private WizardStepListener wasChangedStepListener;
    private final JPanel stepPanel = new JPanel();
    private List<StepGroup> stepGroupList;
    private FinishingType finishingType;
    private Step currentStep;
    private StepGroup currentGroup;
    private boolean equalizeButtons = false;
    private boolean hideFinishButtonsWhenDisabled = false;
    private boolean resetHistoryOnChange = false;
    private boolean canSkipSteps = false;
    private FollowStepPanel followStepPanel;
    private JSplitPane splitPane;

    public void addListener(WizardListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(WizardListener listener) {
        this.listeners.remove(listener);
    }

    void cancel() {
        try {
            this.currentStep.cancel();
            this.notifyCancelled();
        }
        catch (WizardException exception) {
            this.manageException(exception);
        }
    }

    private void close() {
        this.notifyClosed();
    }

    private void confirm() {
        try {
            this.history.setResult(this.currentStep.confirm(this.history));
            this.notifyConfirmed();
            if (this.currentStep.getConfirmOperation().equals((Object)Step.ConfirmOperation.GO_NEXT)) {
                this.exitCurrentStep();
                this.goNext();
                this.enterCurrentStep();
                this.notifyGoneNext();
            }
        }
        catch (WizardException exception) {
            this.manageException(exception);
        }
    }

    private void fillGui() {
        this.followStepPanel = new FollowStepPanel(this.stepGroupList);
        this.addListener(this.followStepPanel);
        Dimension wizardDimension = this.getPreferredDimension();
        this.splitPane = new JSplitPane();
        JPanel controlStepPanel = this.createControlStepPane();
        Dimension controlStepDimension = new Dimension((int)wizardDimension.getWidth() - 200 - this.splitPane.getDividerSize(), (int)wizardDimension.getHeight());
        controlStepPanel.setPreferredSize(controlStepDimension);
        this.splitPane.setOrientation(1);
        this.splitPane.setLeftComponent(this.followStepPanel);
        this.splitPane.setRightComponent(controlStepPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.getLeftComponent().setMinimumSize(new Dimension(0, 0));
        this.splitPane.getRightComponent().setMinimumSize(new Dimension(0, 0));
        this.splitPane.setDividerLocation(this.followStepPanel.getPreferredSize().width);
        this.splitPane.setLastDividerLocation(0);
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitPane, "Center");
        this.setPreferredSize(wizardDimension);
    }

    private Dimension getPreferredDimension() {
        Iterator<StepGroup> stepGroupIterator = this.stepGroupList.iterator();
        int maximumStepHeight = 0;
        int maximumStepWidth = 0;
        while (stepGroupIterator.hasNext()) {
            StepGroup stepGroup = stepGroupIterator.next();
            Set<? extends Step> stepSet = stepGroup.getAll();
            for (Step step : stepSet) {
                int currentStepPreferredWidth;
                int currentStepPreferredHeight = (int)step.getContainer().getPreferredSize().getHeight();
                if (currentStepPreferredHeight > maximumStepHeight) {
                    maximumStepHeight = currentStepPreferredHeight;
                }
                if ((currentStepPreferredWidth = (int)step.getContainer().getPreferredSize().getWidth()) <= maximumStepWidth) continue;
                maximumStepWidth = currentStepPreferredWidth;
            }
        }
        if (maximumStepHeight < this.minimum_height) {
            maximumStepHeight = this.minimum_height;
        }
        if (maximumStepWidth < this.minimum_width) {
            maximumStepWidth = this.minimum_width;
        }
        return new Dimension(200 + maximumStepWidth, maximumStepHeight);
    }

    private void updateButtons() {
        this.previousButton.setEnabled(this.currentStep.hasPrevious() && this.currentStep.canGoPrevious());
        this.confirmButton.setVisible(this.currentStep.getConfirmActionName() != null);
        this.confirmButton.setAction(new ConfirmAction(this.currentStep));
        this.updateProgressButtons();
        this.updateFinishButtons();
    }

    private void updateFinishButtons() {
        if (this.cancelButton != null) {
            this.cancelButton.setEnabled(this.currentStep.canCancel());
            if (this.hideFinishButtonsWhenDisabled) {
                this.cancelButton.setVisible(this.currentStep.canCancel());
            }
        }
        if (this.closeButton != null) {
            this.closeButton.setEnabled(this.currentStep.canClose());
            if (this.hideFinishButtonsWhenDisabled) {
                this.closeButton.setVisible(this.currentStep.canClose());
            }
        }
    }

    private void enterCurrentStep() {
        try {
            this.currentStep.addListener(this.wasChangedStepListener);
            this.currentStep.addListener(this.history);
            this.currentStep.enter(this.history);
            this.stepTitleLabel.setText(this.currentStep.getTitle());
            this.stepInstructionTextArea.setText(this.currentStep.getInstruction());
            this.stepInstructionTextArea.setLineWrap(true);
            this.stepInstructionTextArea.setWrapStyleWord(true);
            this.stepPanel.removeAll();
            this.stepPanel.setLayout(new BorderLayout());
            this.stepPanel.add((Component)this.currentStep.getContainer(), "Center");
            this.updateButtons();
            this.stepPanel.revalidate();
            this.repaint();
        }
        catch (WizardException exception) {
            this.manageException(exception);
        }
    }

    private void exitCurrentStep() {
        this.currentStep.exit(this.history);
        this.currentStep.removeListener(this.wasChangedStepListener);
        this.currentStep.removeListener(this.history);
    }

    private JPanel createControlStepPane() {
        JPanel controlStepPanel = new JPanel();
        controlStepPanel.setLayout(new BorderLayout());
        JPanel headerPanel = this.createHeaderPanel();
        JPanel buttonPanel = this.createButtonPanel();
        controlStepPanel.add((Component)headerPanel, "North");
        controlStepPanel.add((Component)this.stepPanel, "Center");
        controlStepPanel.add((Component)buttonPanel, "South");
        return controlStepPanel;
    }

    private JPanel createButtonPanel() {
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        JPanel browserButtonPanel = new JPanel();
        this.previousButton = new JButton(new GoPreviousAction());
        buttons.add(this.previousButton);
        browserButtonPanel.add(this.previousButton);
        this.nextButton = new JButton(new GoNextAction());
        buttons.add(this.nextButton);
        this.nextButton.setHorizontalTextPosition(2);
        browserButtonPanel.add(this.nextButton);
        JPanel actionButtonPanel = new JPanel();
        this.confirmButton = new JButton();
        buttons.add(this.confirmButton);
        actionButtonPanel.add(this.confirmButton);
        if (this.finishingType.equals((Object)FinishingType.CANCELABLE) || this.finishingType.equals((Object)FinishingType.CANCELABLE_AND_CLOSEABLE)) {
            this.cancelButton = new JButton(new CancelAction());
            buttons.add(this.cancelButton);
            actionButtonPanel.add(this.cancelButton);
        }
        if (this.finishingType.equals((Object)FinishingType.CLOSEABLE) || this.finishingType.equals((Object)FinishingType.CANCELABLE_AND_CLOSEABLE)) {
            this.closeButton = new JButton(new CloseAction());
            buttons.add(this.closeButton);
            actionButtonPanel.add(this.closeButton);
        }
        if (this.equalizeButtons) {
            JButton[] array = new JButton[buttons.size()];
            GUIUtils.matchPreferredSizes(buttons.toArray(array));
        }
        JSeparator separator = new JSeparator(0);
        Insets insets = new Insets(2, 2, 2, 2);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        buttonPanel.add((Component)separator, new GBC(0, 0).horizontal().width(2).center().insets(insets));
        buttonPanel.add((Component)browserButtonPanel, new GBC(0, 1).none().west().insets(insets));
        buttonPanel.add((Component)actionButtonPanel, new GBC(1, 1).none().east().insets(insets));
        return buttonPanel;
    }

    private JPanel createHeaderPanel() {
        this.stepInstructionTextArea.setBackground(this.getBackground());
        this.stepInstructionTextArea.setEditable(false);
        this.stepTitleLabel.setFont(this.stepTitleLabel.getFont().deriveFont(1).deriveFont(16.0f));
        JSeparator separator = new JSeparator(0);
        Insets insets = new Insets(2, 2, 2, 2);
        JPanel headerPanel = new JPanel();
        headerPanel.setLayout(new GridBagLayout());
        int y = 0;
        headerPanel.add((Component)this.stepTitleLabel, new GBC(0, y++).horizontal().insets(insets));
        headerPanel.add((Component)this.stepInstructionTextArea, new GBC(0, y++).horizontal().insets(insets));
        headerPanel.add((Component)separator, new GBC(0, y++).horizontal().insets(insets));
        return headerPanel;
    }

    public void setStepInstructionTextAreaFont(Font font) {
        this.stepInstructionTextArea.setFont(font);
    }

    private void goNext() {
        Step nextStep;
        StepGroup nextStepGroup;
        Class<? extends Step> stepClass = this.currentStep.getNext(this.history);
        if (stepClass.equals(this.currentStep.getClass())) {
            return;
        }
        if (!this.canSkipSteps) {
            nextStepGroup = this.currentGroup;
            nextStep = nextStepGroup.get(stepClass);
            if (nextStep == null) {
                int groupIndex = this.stepGroupList.indexOf(nextStepGroup);
                if (groupIndex == this.stepGroupList.size() - 1) {
                    throw new IllegalStateException(MessageFormat.format("Tentativa de obter um passo inexistente.\nO passo atual \u00e9 da classe {0} e o passo requerido \u00e9 da classe {1}.", this.currentStep.getClass(), stepClass));
                }
                nextStepGroup = this.stepGroupList.get(groupIndex + 1);
                nextStep = nextStepGroup.get(stepClass);
                if (nextStep == null) {
                    throw new IllegalStateException(MessageFormat.format("Tentativa de obter um passo inexistente.\nO passo atual \u00e9 da classe {0} e o passo requerido \u00e9 da classe {1}.", this.currentStep.getClass(), stepClass));
                }
            }
        } else {
            StepGroup o;
            nextStep = null;
            nextStepGroup = null;
            Iterator<StepGroup> i$ = this.stepGroupList.iterator();
            while (i$.hasNext() && (nextStep = (nextStepGroup = (o = i$.next())).get(stepClass)) == null) {
            }
            if (nextStep == null) {
                throw new IllegalStateException(MessageFormat.format("Tentativa de obter um passo inexistente.\nO passo atual \u00e9 da classe {0} e o passo requerido \u00e9 da classe {1}.", this.currentStep.getClass(), stepClass));
            }
        }
        nextStep.setPrevious(this.currentStep);
        this.currentStep = nextStep;
        this.currentGroup = nextStepGroup;
    }

    protected Step getStep(Class<? extends Step> stepClass) {
        for (StepGroup o : this.stepGroupList) {
            StepGroup stepGroup = o;
            Step step = stepGroup.get(stepClass);
            if (step == null) continue;
            return step;
        }
        return null;
    }

    private void goPrevious() {
        if (!this.canSkipSteps) {
            StepGroup stepGroup = this.currentGroup;
            Step previousStep = this.currentStep.getPrevious();
            if (!stepGroup.contains(previousStep)) {
                int groupIndex = this.stepGroupList.indexOf(stepGroup);
                if (groupIndex == 0) {
                    throw new IllegalStateException(MessageFormat.format("Tentativa de obter um passo inexistente.\nO passo atual \u00e9 da classe {0} e o passo requerido \u00e9 da classe {1}.", this.currentStep.getClass(), previousStep.getClass()));
                }
                stepGroup = this.stepGroupList.get(groupIndex - 1);
                if (!stepGroup.contains(previousStep)) {
                    throw new IllegalStateException(MessageFormat.format("Tentativa de obter um passo inexistente.\nO passo atual \u00e9 da classe {0} e o passo requerido \u00e9 da classe {1}.", this.currentStep.getClass(), previousStep.getClass()));
                }
            }
            this.currentStep = previousStep;
            this.currentGroup = stepGroup;
        } else {
            StepGroup sg;
            Step nextStep = null;
            StepGroup nextStepGroup = null;
            Class<?> stepClass = this.currentStep.getPrevious().getClass();
            Iterator<StepGroup> i$ = this.stepGroupList.iterator();
            while (i$.hasNext() && (nextStep = (nextStepGroup = (sg = i$.next())).get(stepClass)) == null) {
            }
            if (nextStep == null) {
                throw new IllegalStateException(MessageFormat.format("Tentativa de obter um passo inexistente.\nO passo atual \u00e9 da classe {0} e o passo requerido \u00e9 da classe {1}.", this.currentStep.getClass(), stepClass));
            }
            this.currentStep = nextStep;
            this.currentGroup = nextStepGroup;
        }
    }

    private void manageException(WizardException exception) {
        this.notifyException(exception);
        this.close();
    }

    private void notifyCancelled() {
        for (final WizardListener listener : this.listeners) {
            SwingThreadDispatcher.invokeLater(new Runnable(){

                @Override
                public void run() {
                    listener.wasCancelled(Wizard.this.currentStep);
                }
            });
        }
    }

    private void notifyClosed() {
        for (final WizardListener listener : this.listeners) {
            SwingThreadDispatcher.invokeLater(new Runnable(){

                @Override
                public void run() {
                    listener.wasClosed(Wizard.this.currentStep);
                }
            });
        }
    }

    private void notifyConfirmed() {
        for (WizardListener listener : this.listeners) {
            listener.wasConfirmed(this.currentStep, this.history.getResult());
        }
    }

    private void notifyException(WizardException exception) {
        for (WizardListener listener : this.listeners) {
            listener.wasHappenedException(this.currentStep, exception);
        }
    }

    private void notifyGoneNext() {
        for (WizardListener listener : this.listeners) {
            listener.wasGoneNext(this.currentStep, this.history);
        }
    }

    private void notifyGonePrevious() {
        for (WizardListener listener : this.listeners) {
            listener.wasGonePrevious(this.currentStep, this.history);
        }
    }

    private void updateProgressButtons() {
        this.confirmButton.setEnabled(this.currentStep.canConfirm());
        this.nextButton.setEnabled(this.currentStep.hasNext(this.history) && this.currentStep.canGoNext(this.history));
    }

    private void translateSteps(Object data) {
        for (StepGroup stepGroup : this.stepGroupList) {
            Set<? extends Step> stepSet = stepGroup.getAll();
            for (Step step : stepSet) {
                step.translate(this.history, data);
            }
        }
        while (this.currentStep.isTranslationCompleted(this.history)) {
            this.goNext();
            this.notifyGoneNext();
        }
    }

    private void createWizard(Class<? extends Step> firstStepClass, List<? extends StepGroup> stepGroupList, Map<String, Object> globalData, FinishingType finishingType) {
        this.wasChangedStepListener = new WizardStepListener();
        this.listeners = new HashSet<WizardListener>();
        this.history = new History(this, this.resetHistoryOnChange);
        this.history.addGlobal(globalData);
        this.addListener(this.history);
        this.stepGroupList = Collections.unmodifiableList(stepGroupList);
        this.currentGroup = this.stepGroupList.get(0);
        this.currentStep = this.currentGroup.get(firstStepClass);
        this.finishingType = finishingType;
        this.fillGui();
    }

    public Wizard(Class<? extends Step> firstStepClass, List<StepGroup> stepGroupList) {
        this(firstStepClass, stepGroupList, Wizard.initGlobalData(), FinishingType.CANCELABLE_AND_CLOSEABLE, false);
    }

    public Wizard(Class<? extends Step> firstStepClass, List<StepGroup> stepGroupList, FinishingType wizardType) {
        this(firstStepClass, stepGroupList, Wizard.initGlobalData(), wizardType, false);
    }

    public Wizard(Class<? extends Step> firstStepClass, List<StepGroup> stepGroupList, FinishingType wizardType, boolean equalizeButtons) {
        this(firstStepClass, stepGroupList, Wizard.initGlobalData(), wizardType, equalizeButtons);
    }

    public Wizard(Class<? extends Step> firstStepClass, List<StepGroup> stepGroupList, FinishingType wizardType, boolean equalizeButtons, boolean hideFinishButtonsWhenDisabled) {
        this(firstStepClass, stepGroupList, Wizard.initGlobalData(), wizardType, equalizeButtons, hideFinishButtonsWhenDisabled);
    }

    public Wizard(Class<? extends Step> firstStepClass, List<StepGroup> stepGroupList, Map<String, Object> globalData) {
        this(firstStepClass, stepGroupList, globalData, FinishingType.CANCELABLE_AND_CLOSEABLE, false);
    }

    public Wizard(Class<? extends Step> firstStepClass, List<StepGroup> stepGroupList, Object stepData, FinishingType wizardType, boolean resetHistoryOnchange) {
        this(firstStepClass, stepGroupList, Wizard.initGlobalData(), stepData, wizardType, false, resetHistoryOnchange);
    }

    private static Map<String, Object> initGlobalData() {
        return Collections.emptyMap();
    }

    public Wizard(Class<? extends Step> firstStepClass, List<StepGroup> stepGroupList, Object stepData, FinishingType wizardType) {
        this(firstStepClass, stepGroupList, Wizard.initGlobalData(), stepData, wizardType, false, false);
    }

    public Wizard(Class<? extends Step> firstStepClass, List<StepGroup> stepGroupList, Map<String, Object> globalData, Object stepData) {
        this(firstStepClass, stepGroupList, globalData, stepData, FinishingType.CANCELABLE_AND_CLOSEABLE, false, false);
    }

    public Wizard(Class<? extends Step> firstStepClass, List<StepGroup> stepGroupList, Object stepData) {
        this(firstStepClass, stepGroupList, Wizard.initGlobalData(), stepData, FinishingType.CANCELABLE_AND_CLOSEABLE, false, false);
    }

    public Wizard(Class<? extends Step> firstStepClass, List<StepGroup> stepGroupList, Map<String, Object> globalData, FinishingType wizardType, boolean equalizeButtons) {
        this(firstStepClass, stepGroupList, globalData, wizardType, equalizeButtons, false);
    }

    public Wizard(Class<? extends Step> firstStepClass, List<StepGroup> stepGroupList, Map<String, Object> globalData, FinishingType wizardType, boolean equalizeButtons, boolean hideFinishButtonsWhenDisabled) {
        this.equalizeButtons = equalizeButtons;
        this.hideFinishButtonsWhenDisabled = hideFinishButtonsWhenDisabled;
        this.createWizard(firstStepClass, stepGroupList, globalData, wizardType);
        this.enterCurrentStep();
    }

    public Wizard(Class<? extends Step> firstStepClass, List<StepGroup> stepGroupList, Map<String, Object> globalData, Object stepData, FinishingType wizardType, boolean equalizeButtons, boolean resetHistoryOnChange) {
        this.resetHistoryOnChange = resetHistoryOnChange;
        this.equalizeButtons = equalizeButtons;
        this.createWizard(firstStepClass, stepGroupList, globalData, wizardType);
        this.translateSteps(stepData);
        this.enterCurrentStep();
    }

    public void setCanSkipSteps(boolean canSkipSteps) {
        this.canSkipSteps = canSkipSteps;
    }

    public void setMinHeight(int height) {
        this.minimum_height = height;
        this.setPreferredSize(this.getPreferredDimension());
    }

    public void setMinWidth(int width) {
        this.minimum_width = width;
        this.setPreferredSize(this.getPreferredDimension());
    }

    public boolean isFollowStepPanelHidden() {
        return this.splitPane.getLeftComponent().getSize().width <= 0;
    }

    public void hideFollowStepPanel() {
        this.splitPane.setDividerLocation(0);
        this.splitPane.setLastDividerLocation(this.splitPane.getLeftComponent().getPreferredSize().width);
    }

    public void showFollowStepPanel() {
        this.splitPane.setDividerLocation(this.splitPane.getLeftComponent().getPreferredSize().width);
    }

    private final class WizardStepListener
    implements StepListener {
        private WizardStepListener() {
        }

        @Override
        public void wasChanged(Step step) {
            Wizard.this.updateProgressButtons();
        }
    }

    private final class GoPreviousAction
    extends AbstractAction {
        private static final String PREVIOUS = "previous";
        private static final String NEXT_SHORT_DESCRIPTION = "previousShortDescription";

        @Override
        public void actionPerformed(ActionEvent e) {
            Wizard.this.exitCurrentStep();
            Wizard.this.goPrevious();
            Wizard.this.enterCurrentStep();
            Wizard.this.notifyGonePrevious();
        }

        GoPreviousAction() {
            this.putValue("SmallIcon", GUIResources.BACK_ICON);
            this.putValue("Name", LNG.get((String)(LNG_KEY_PREFFIX + PREVIOUS)));
            this.putValue("ShortDescription", LNG.get((String)(LNG_KEY_PREFFIX + NEXT_SHORT_DESCRIPTION)));
        }
    }

    private final class GoNextAction
    extends AbstractAction {
        private static final String NEXT = "next";
        private static final String NEXT_SHORT_DESCRIPTION = "nextShortDescription";

        @Override
        public void actionPerformed(ActionEvent e) {
            Wizard.this.exitCurrentStep();
            Wizard.this.goNext();
            Wizard.this.enterCurrentStep();
            Wizard.this.notifyGoneNext();
        }

        GoNextAction() {
            this.putValue("SmallIcon", GUIResources.FORWARD_ICON);
            this.putValue("Name", LNG.get((String)(LNG_KEY_PREFFIX + NEXT)));
            this.putValue("ShortDescription", LNG.get((String)(LNG_KEY_PREFFIX + NEXT_SHORT_DESCRIPTION)));
        }
    }

    private final class ConfirmAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            Wizard.this.confirm();
        }

        ConfirmAction(Step step) {
            this.putValue("Name", step.getConfirmActionName());
            this.putValue("ShortDescription", step.getConfirmActionTooltip());
        }
    }

    private final class CloseAction
    extends AbstractAction {
        private static final String CLOSE_SHORT_DESCRIPTION = "closeShortDescription";

        @Override
        public void actionPerformed(ActionEvent e) {
            Wizard.this.close();
        }

        private CloseAction() {
            this.putValue("Name", LNG.get((String)"javautils.close"));
            this.putValue("ShortDescription", LNG.get((String)(LNG_KEY_PREFFIX + CLOSE_SHORT_DESCRIPTION)));
        }
    }

    private final class CancelAction
    extends AbstractAction {
        private static final String CANCEL_SHORT_DESCRIPTION = "cancelShortDescription";

        @Override
        public void actionPerformed(ActionEvent e) {
            Wizard.this.cancel();
        }

        CancelAction() {
            this.putValue("Name", LNG.get((String)"javautils.cancel"));
            this.putValue("ShortDescription", LNG.get((String)(LNG_KEY_PREFFIX + CANCEL_SHORT_DESCRIPTION)));
        }
    }

    public static enum FinishingType {
        CANCELABLE,
        CLOSEABLE,
        CANCELABLE_AND_CLOSEABLE;

    }
}

