package tecgraf.javautils.gui.wizard.utils.changedlisteners;

import tecgraf.javautils.gui.selector.ContainerSelectionListener;
import tecgraf.javautils.gui.wizard.Step;
import tecgraf.javautils.gui.wizard.WasChangedListener;

/**
 *
 * Representa um ouvinte de eventos de mudana de estado que notifica a um passo
 * que tal evento ocorreu.
 *
 * @author Tecgraf/PUC-Rio
 *
 */
public final class WasChangedContainerSelectionListener extends
  WasChangedListener implements ContainerSelectionListener {

  /**
   * {@inheritDoc}
   */
  @Override
  public void containerChanged() {
    notifyChangedToStep();
  }

  /**
   * Cria um ouvinte de eventos de mudana de estado que notificar a um passo
   * da ocorrncia desse evento.
   *
   * @param step O passo a ser notificado.
   */
  public WasChangedContainerSelectionListener(Step step) {
    super(step);
  }
}
