
package tecgraf.javautils.gui.wizard.utils.changedlisteners;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import tecgraf.javautils.gui.wizard.Step;
import tecgraf.javautils.gui.wizard.WasChangedListener;

/**
 * Representa um ouvinte de eventos de documento que notifica a um passo que tal
 * evento ocorreu.
 *
 * @author Tecgraf/PUC-Rio
 */
public final class WasChangedDocumentListener extends WasChangedListener
  implements DocumentListener {

  /**
   * {@inheritDoc}
   */

  @Override
  public void changedUpdate(DocumentEvent e) {
    notifyChangedToStep();

  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void insertUpdate(DocumentEvent e) {
    notifyChangedToStep();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void removeUpdate(DocumentEvent e) {
    notifyChangedToStep();
  }

  /**
   * Cria um ouvinte de eventos de documento que notificar a um passo da
   * ocorrncia desse evento.
   *
   * @param step o passo a ser notificado.
   */
  public WasChangedDocumentListener(Step step) {
    super(step);
  }
}
